/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.ui.internal.differenceGroup;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.ConflictNode;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrusrt.umlrt.core.utils.PackageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class ProtocolMessageGroupExtender
implements IDifferenceGroupExtender {
    public boolean handle(TreeNode treeNode) {
        if (this.isNonConflictingCollaborationOrOperationMatch(treeNode)) {
            Match match = (Match)treeNode.getData();
            return this.getProtocolFromMatch(match).isPresent();
        }
        return false;
    }

    private boolean isNonConflictingCollaborationOrOperationMatch(TreeNode treeNode) {
        EObject data = treeNode.getData();
        return (this.isCollaborationMatch(data) || this.isOperationMatch(data)) && !this.isChildOfConflictNode(treeNode);
    }

    private boolean isCollaborationMatch(EObject eObject) {
        return eObject instanceof Match && UMLRTCompareUtil.getAnyMatchValue((Match)((Match)eObject)) instanceof Collaboration;
    }

    private boolean isOperationMatch(EObject eObject) {
        return eObject instanceof Match && UMLRTCompareUtil.getAnyMatchValue((Match)((Match)eObject)) instanceof Operation;
    }

    private boolean isChildOfConflictNode(TreeNode treeNode) {
        TreeNode parent = treeNode;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof ConflictNode)) continue;
            return true;
        }
        return false;
    }

    private Optional<Collaboration> getProtocolFromMatch(Match match) {
        return this.getProtocol(UMLRTCompareUtil.getAnyMatchValue((Match)match));
    }

    private Optional<Collaboration> getProtocol(EObject eObject) {
        Package protocolContainer = PackageUtils.getNearestPackage((EObject)eObject);
        Collaboration protocol = ProtocolContainerUtils.getProtocol((Package)protocolContainer);
        return Optional.fromNullable((Object)protocol);
    }

    public void addChildren(TreeNode treeNode) {
        if (treeNode.getParent() == null) {
            return;
        }
        EObject data = treeNode.getData();
        Match match = (Match)data;
        Comparison comparison = match.getComparison();
        Optional<Collaboration> protocol = this.getProtocolFromMatch(match);
        if (this.isOperationMatch((EObject)match)) {
            Optional<TreeNode> existingProtocolTreeNode = this.getProtocolTreeNode(protocol, treeNode);
            if (!existingProtocolTreeNode.isPresent() && protocol.isPresent()) {
                TreeNode parentOfOperationTreeNode = treeNode.getParent();
                Match protocolMatch = comparison.getMatch((EObject)protocol.get());
                parentOfOperationTreeNode.setData((EObject)protocolMatch);
            }
        } else if (this.isCollaborationMatch((EObject)match) && protocol.isPresent()) {
            TreeNode parentTreeNode = treeNode.getParent();
            List<TreeNode> operationTreeNodes = this.getProtocolMessageTreeNodes((Collaboration)protocol.get(), Lists.newArrayList((Object[])new TreeNode[]{parentTreeNode}));
            for (TreeNode operationTreeNode : operationTreeNodes) {
                treeNode.getChildren().add((Object)operationTreeNode);
            }
        }
    }

    private Optional<TreeNode> getProtocolTreeNode(Optional<Collaboration> protocol, TreeNode treeNode) {
        if (!protocol.isPresent()) {
            return Optional.absent();
        }
        HashSet<TreeNode> checkedTreeNodes = new HashSet<TreeNode>();
        TreeNode parent = treeNode;
        while ((parent = parent.getParent()) != null) {
            Optional<TreeNode> protocolTreeNode = this.getProtocolTreeNodeFromChildren(protocol, parent, checkedTreeNodes);
            if (protocolTreeNode.isPresent()) {
                return protocolTreeNode;
            }
            checkedTreeNodes.add(parent);
        }
        return Optional.absent();
    }

    private Optional<TreeNode> getProtocolTreeNodeFromChildren(Optional<Collaboration> protocol, TreeNode parent, Set<TreeNode> checkedTreeNodes) {
        if (protocol.isPresent() && !checkedTreeNodes.contains(parent)) {
            for (TreeNode childTreeNode : parent.getChildren()) {
                Match currentMatch;
                Optional<Collaboration> currentProtocol;
                if (this.isCollaborationMatch(childTreeNode) && (currentProtocol = this.getProtocolFromMatch(currentMatch = (Match)childTreeNode.getData())).isPresent() && ((Collaboration)protocol.get()).equals(currentProtocol.get())) {
                    return Optional.of((Object)childTreeNode);
                }
                Optional<TreeNode> treeNodeFromChildren = this.getProtocolTreeNodeFromChildren(protocol, childTreeNode, checkedTreeNodes);
                if (treeNodeFromChildren.isPresent()) {
                    return treeNodeFromChildren;
                }
                checkedTreeNodes.add(childTreeNode);
            }
        }
        return Optional.absent();
    }

    private boolean isCollaborationMatch(TreeNode treeNode) {
        return treeNode.getData() instanceof Match && UMLRTCompareUtil.getAnyMatchValue((Match)((Match)treeNode.getData())) instanceof Collaboration;
    }

    private List<TreeNode> getProtocolMessageTreeNodes(Collaboration protocol, List<TreeNode> treeNodes) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (TreeNode currentTreeNode : treeNodes) {
            Match operationMatch;
            Optional<Collaboration> currentProtocol;
            EObject data = currentTreeNode.getData();
            if (this.isOperationMatch(data) && (currentProtocol = this.getProtocolFromMatch(operationMatch = (Match)data)).isPresent() && protocol.equals(currentProtocol.get())) {
                list.add((Object)currentTreeNode);
            }
            list.addAll(this.getProtocolMessageTreeNodes(protocol, (List<TreeNode>)currentTreeNode.getChildren()));
        }
        return list.build();
    }
}

