/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.AbstractUMLRTChangeFactory;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolMessageChange;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTCompareFactory;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRTProtocolMessageChangeFactory
extends AbstractUMLRTChangeFactory {
    public boolean handles(Diff input) {
        return this.isAddDeleteOfProtocolMessage(input) || UMLRTCompareUtil.isAttributeChangeOfProtocolMessage(input);
    }

    private boolean isAddDeleteOfProtocolMessage(Diff diff) {
        if (diff instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)diff;
            EObject value = referenceChange.getValue();
            EReference reference = referenceChange.getReference();
            return this.isInterfaceOwnedOperationReference(reference) && RTMessageUtils.isRTMessage((EObject)value);
        }
        return false;
    }

    private boolean isInterfaceOwnedOperationReference(EReference reference) {
        return UMLPackage.Literals.INTERFACE__OWNED_OPERATION.equals(reference);
    }

    public Class<? extends UMLDiff> getExtensionKind() {
        return ProtocolMessageChange.class;
    }

    public UMLDiff createExtension() {
        return UMLRTCompareFactory.eINSTANCE.createProtocolMessageChange();
    }

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return input.getKind();
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        super.setRefiningChanges(extension, extensionKind, refiningDiff);
        HashSet additionalChanges = new HashSet();
        for (Diff diff : extension.getRefinedBy()) {
            additionalChanges.addAll(diff.getRefines());
        }
        additionalChanges.addAll(refiningDiff.getRefines());
        additionalChanges.remove(extension);
        extension.getRefinedBy().addAll(additionalChanges);
        extension.getRefinedBy().add((Object)refiningDiff);
    }

    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return new AbstractUMLChangeFactory.DiscriminantsGetter(this){

            public Set<EObject> caseOperation(Operation operation) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.add((Object)operation);
                CallEvent callEvent = MessageUtils.getCallEvent((Operation)operation);
                if (callEvent != null) {
                    builder.add((Object)callEvent);
                }
                return builder.build();
            }

            public Set<EObject> caseCallEvent(CallEvent callEvent) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                Operation operation = callEvent.getOperation();
                builder.add((Object)operation);
                builder.add((Object)callEvent);
                return builder.build();
            }
        };
    }

    protected EObject getDiscriminant(Diff input) {
        return (EObject)Iterables.find((Iterable)this.getDiscriminants(input), (Predicate)Predicates.instanceOf(Operation.class), null);
    }
}

