/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.internal.factories.AbstractDiagramChangeFactory;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.DiagramChangesHandler;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.DiagramChangesHandlerService;

public abstract class AbstractUMLRTDiagramChangeFactory
extends AbstractDiagramChangeFactory {
    public Set<EObject> getAffectedShapes(Diff diff) {
        DiagramChangesHandler handler = DiagramChangesHandlerService.getService().getHandlerForDiff(diff);
        if (handler != null) {
            return handler.getShapes(diff);
        }
        return Collections.emptySet();
    }

    public Diff create(Diff input) {
        Diff ret = super.create(input);
        this.setRequiredAutoCreatedDiagramChanges(ret, input);
        return ret;
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        Comparison comparison = ComparisonUtil.getComparison((Diff)refiningDiff);
        Set<EObject> affectedShapes = this.getAffectedShapes(refiningDiff);
        ImmutableSet.Builder refiningChanges = ImmutableSet.builder();
        refiningChanges.add((Object)refiningDiff);
        for (EObject shape : affectedShapes) {
            Match match = comparison.getMatch(shape);
            refiningChanges.addAll(Iterables.filter((Iterable)match.getAllDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)extension.getSource())));
        }
        refiningChanges.addAll((Iterable)Collections2.filter((Collection)comparison.getDifferences(), AbstractUMLRTDiagramChangeFactory.isChangeOfAffectedShapes(affectedShapes)));
        extension.getRefinedBy().addAll((Collection)refiningChanges.build());
    }

    public void setRequiredAutoCreatedDiagramChanges(Diff extension, Diff diff) {
        DiagramChangesHandler handler = DiagramChangesHandlerService.getService().getHandlerForDiff(diff);
        if (handler == null) {
            return;
        }
        Set<EObject> shapesOfImpliedDiffs = handler.getAutomaticallyCreatedShapes(diff);
        if (shapesOfImpliedDiffs == null || shapesOfImpliedDiffs.isEmpty()) {
            return;
        }
        ImmutableSet.Builder impliedDiffs = ImmutableSet.builder();
        Comparison comparison = diff.getMatch().getComparison();
        for (EObject shape : shapesOfImpliedDiffs) {
            Match match = comparison.getMatch(shape);
            impliedDiffs.addAll(Iterables.filter((Iterable)match.getAllDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)extension.getSource())));
        }
        impliedDiffs.addAll((Iterable)Collections2.filter((Collection)comparison.getDifferences(), AbstractUMLRTDiagramChangeFactory.isChangeOfAffectedShapes(shapesOfImpliedDiffs)));
        ImmutableSet autoCreatedDiagramChanges = impliedDiffs.build();
        UMLRTCompareUtil.markAsAutoDiagramChanges((Collection<Diff>)autoCreatedDiagramChanges);
        extension.getRequires().addAll((Collection)autoCreatedDiagramChanges);
    }

    public static Predicate<? super Diff> isChangeOfAffectedShapes(final Set<EObject> affectedShapes) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return affectedShapes.contains(UMLRTCompareUtil.getChangedValue(input));
            }
        };
    }
}

