/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTCompareUtil;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.diagram.AbstractCapsuleDiagramChangeHandler;
import org.eclipse.uml2.uml.Property;

public class CapsulePartDiagramChangeHandler
extends AbstractCapsuleDiagramChangeHandler {
    @Override
    public double isHandlerFor(Diff diff) {
        if (this.isReferenceChangeOfCapsulePartShape(diff) && UMLRTCompareUtil.isViewPersistedChildrenReference(((ReferenceChange)diff).getReference())) {
            return 10.0;
        }
        return Double.NaN;
    }

    private boolean isReferenceChangeOfCapsulePartShape(Diff input) {
        if (!(input instanceof ReferenceChange)) {
            return false;
        }
        EObject value = ((ReferenceChange)input).getValue();
        if (!(value instanceof Shape)) {
            return false;
        }
        EObject element = ((Shape)value).getElement();
        return element instanceof Property && CapsulePartUtils.isCapsulePart((Property)((Property)element));
    }

    @Override
    public Set<EObject> getShapes(Diff diff) {
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        ReferenceChange refChange = (ReferenceChange)diff;
        Shape capsulePartShape = (Shape)refChange.getValue();
        shapes.add((EObject)capsulePartShape);
        shapes.addAll(this.collectAdditionalShapesForElement(capsulePartShape));
        return shapes;
    }

    private Collection<EObject> collectAdditionalShapesForElement(Shape capsulePartShape) {
        LinkedHashSet<EObject> shapes = new LinkedHashSet<EObject>();
        EObject capsulePart = capsulePartShape.getElement();
        EObject container = capsulePartShape.eContainer();
        for (Object child : container.eContents()) {
            EObject eObject;
            if (!(child instanceof EObject) || !this.isShapeWithElement(eObject = (EObject)child, capsulePartShape.getElement())) continue;
            shapes.add(eObject);
        }
        Diagram diagram = capsulePartShape.getDiagram();
        for (Object edge : diagram.getEdges()) {
            if (!(edge instanceof Edge) || !this.isStereotypeCommentEdge(edge, capsulePart)) continue;
            shapes.add((EObject)edge);
        }
        return shapes;
    }
}

