/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.decorator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public abstract class AbstractUMLRTDecorator<T extends IDecoratorTarget>
implements IDecorator,
NotificationListener {
    private List<Decoration> decorations = new ArrayList<Decoration>(3);
    private T decoratorTarget;
    private IDisposable listenerRegistration;

    public AbstractUMLRTDecorator(Class<? extends T> decoratorType, IDecoratorTarget decoratorTarget) {
        Assert.isLegal((boolean)decoratorType.isInstance(decoratorTarget));
        this.decoratorTarget = (IDecoratorTarget)decoratorType.cast(decoratorTarget);
    }

    protected AbstractUMLRTDecorator(T decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    protected T getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public void activate() {
        TransactionalEditingDomain domain;
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        if (editPart == null) {
            return;
        }
        EObject semantic = EMFHelper.getEObject((Object)editPart);
        if (this.matchesTarget(semantic) && (domain = TransactionUtil.getEditingDomain((EObject)semantic)) != null) {
            DiagramEventBroker broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
            broker.addNotificationListener(semantic, (NotificationListener)this);
            this.listenerRegistration = () -> broker.removeNotificationListener(semantic, (NotificationListener)this);
        }
        this.refresh();
    }

    protected boolean matchesTarget(EObject semanticElement) {
        return true;
    }

    public void deactivate() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.dispose();
            this.listenerRegistration = null;
        }
        this.removeDecorations();
    }

    public void addDecoration(IDecoration decoration) {
        Assert.isTrue((boolean)(decoration instanceof Decoration));
        this.decorations.add((Decoration)decoration);
    }

    protected void removeDecorations() {
        this.decorations.stream().forEach(dec -> this.getDecoratorTarget().removeDecoration((IDecoration)dec));
        this.decorations.clear();
    }

    public void notifyChanged(Notification notification) {
        this.refresh();
    }

    public void refresh() {
        this.removeDecorations();
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        EObject semanticElement = (EObject)this.getDecoratorTarget().getAdapter(EObject.class);
        if (editPart instanceof IGraphicalEditPart && semanticElement != null && this.matchesTarget(semanticElement)) {
            this.addDecorations((IGraphicalEditPart)editPart, semanticElement);
        }
    }

    protected abstract void addDecorations(IGraphicalEditPart var1, EObject var2);
}

