/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop;

import java.util.List;
import java.util.stream.Collectors;
import javax.xml.soap.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.BorderMarchIterator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.ILocationIterator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ProtocolToPortOnPartDropStrategy
extends TransactionalDropStrategy {
    private static final String EXTERNAL_PORT_SHAPE_ID = "org.eclipse.papyrusrt.umlrt.tooling.diagram.capsulestructurediagram.BasicPort_Shape";

    public String getLabel() {
        return "Create Port";
    }

    public String getDescription() {
        return "Drop protocol to create an external behavior port";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrusrt.umlrt.tooling.diagram.common.protocolToExternalBehaviorPortOnPartDrop";
    }

    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        Point location;
        EObject targetElement;
        List<Classifier> protocols;
        DropObjectsRequest drop;
        Command result = null;
        if (request instanceof DropObjectsRequest && (drop = this.getDropObjectsRequest(request)) != null && this.canDrop(protocols = this.getDroppedProtocols(drop), targetEditPart, targetElement = this.getTargetSemanticElement(targetEditPart), location = drop.getLocation())) {
            Property capsulePart = (Property)targetElement;
            if (protocols.size() == 1) {
                result = this.getCreatePortCommand(protocols.get(0), capsulePart, targetEditPart, location);
            } else {
                IFigure figure = ((IGraphicalEditPart)targetEditPart).getFigure();
                Rectangle bounds = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)bounds);
                CompoundCommand compound = new CompoundCommand();
                ILocationIterator marcher = BorderMarchIterator.from(location, bounds);
                int stride = IRTPortEditPart.getDefaultSize((boolean)true).width * 5 / 3;
                for (Classifier protocol : protocols) {
                    Command createPort = this.getCreatePortCommand(protocol, capsulePart, targetEditPart, location);
                    if (createPort != null) {
                        compound.add(createPort);
                        location = marcher.next(stride);
                    }
                    result = compound;
                }
            }
        }
        return result;
    }

    protected Command getCreatePortCommand(final Classifier protocol, Property capsulePart, EditPart partEditPart, Point location) {
        CompoundCommand result = null;
        CreateElementRequest createElement = new CreateElementRequest((EObject)capsulePart, ElementTypeRegistry.getInstance().getType(EXTERNAL_PORT_SHAPE_ID));
        final CreateElementRequestAdapter createAdapter = new CreateElementRequestAdapter(createElement);
        CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(createAdapter, Node.class, "Port_Shape", ((GraphicalEditPart)partEditPart).getDiagramPreferencesHint());
        CreateViewAndElementRequest request = new CreateViewAndElementRequest(descriptor);
        request.setLocation(location.getCopy());
        Command createCommand = partEditPart.getCommand((Request)request);
        if (createCommand != null && createCommand.canExecute()) {
            result = new CompoundCommand();
            result.add(createCommand);
            AbstractTransactionalCommand setType = new AbstractTransactionalCommand(((IGraphicalEditPart)partEditPart).getEditingDomain(), "Set Type", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    CommandResult result;
                    Port port = (Port)createAdapter.getAdapter(Port.class);
                    if (port == null) {
                        result = CommandResult.newErrorCommandResult((String)"Port not created to set its type");
                    } else {
                        IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)port);
                        if (edit == null) {
                            result = CommandResult.newErrorCommandResult((String)("No edit provider for " + port));
                        } else {
                            ICommand delegate = edit.getEditCommand((IEditCommandRequest)new SetRequest(this.getEditingDomain(), (EObject)port, (EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, (Object)protocol));
                            if (delegate == null) {
                                result = CommandResult.newErrorCommandResult((String)("No command provided to set type of " + port));
                            } else {
                                delegate.execute(monitor, info);
                                result = CommandResult.newOKCommandResult((Object)port);
                            }
                        }
                    }
                    return result;
                }
            };
            result.add((Command)new ICommandProxy((ICommand)setType));
        }
        return result;
    }

    private List<Classifier> getDroppedProtocols(DropObjectsRequest dropRequest) {
        return this.getSourceEObjects((Request)dropRequest).stream().filter(Classifier.class::isInstance).map(Classifier.class::cast).filter(ProtocolUtils::isProtocol).collect(Collectors.toList());
    }

    protected boolean canDrop(List<Classifier> protocols, EditPart ontoEditPart, EObject ontoElement, Point location) {
        return !protocols.isEmpty() && ontoElement instanceof Property && CapsulePartUtils.isCapsulePart((Property)((Property)ontoElement)) && !this.isInInterior(ontoEditPart, location);
    }

    private boolean isInInterior(EditPart editPart, Point location) {
        IFigure figure = ((IGraphicalEditPart)editPart).getFigure();
        Rectangle bounds = figure.getBounds();
        location = location.getCopy();
        figure.getParent().translateToRelative((Translatable)location);
        Rectangle interior = bounds.getShrinked(10, 10);
        return interior.contains(location);
    }
}

