/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.parts.ResizablePortEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.MultiplicityElementAdapter;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPropertyUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.figures.RTPortFigure;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTBehaviorPortEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTPortResizableEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTSemanticEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.ReificationListener;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Property;

public class RTPortEditPart
extends ResizablePortEditPart
implements IRTPortEditPart,
IInheritableEditPart {
    private static final int LAYER_OPACITY = 0;
    private static final int X_OFFSET = 2;
    private static final int Y_OFFSET = 2;
    private static final int LAYER_NUMBER = 1;
    private MultiplicityElementAdapter multiplicityValueListener;
    private ReificationListener reificationListener = this::reificationStateChanged;

    public RTPortEditPart(View view) {
        super(view);
    }

    public EObject resolveSemanticElement() {
        return EditPartInheritanceUtils.resolveSemanticElement(this, super.resolveSemanticElement());
    }

    public Object getAdapter(Class key) {
        return EditPartInheritanceUtils.getAdapter(this, key, super.getAdapter(key));
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new RTSemanticEditPolicy());
        this.installEditPolicy("BehaviorPortPolicy", (EditPolicy)new RTBehaviorPortEditPolicy());
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        if (this.hasNotationView() && this.getNotationView().isSetElement()) {
            this.getMultiplicityListener().adapt((Notifier)this.getUMLElement());
        }
        this.getUMLRTElement().ifPresent(rt -> rt.addReificationListener(this.reificationListener));
    }

    protected void removeSemanticListeners() {
        this.getUMLRTElement().ifPresent(rt -> rt.removeReificationListener(this.reificationListener));
        super.removeSemanticListeners();
        if (this.multiplicityValueListener != null) {
            MultiplicityElement target = this.multiplicityValueListener.getTarget();
            if (target != null) {
                this.multiplicityValueListener.unadapt((Notifier)target);
            }
            this.multiplicityValueListener = null;
        }
    }

    protected MultiplicityElementAdapter getMultiplicityListener() {
        if (this.multiplicityValueListener == null) {
            this.multiplicityValueListener = new MultiplicityElementAdapter(){

                protected void handleMultiplicityChanged(Notification notification) {
                    RTPortEditPart.this.refreshVisuals();
                }
            };
        }
        return this.multiplicityValueListener;
    }

    public RTPortFigure getPrimaryShape() {
        return (RTPortFigure)this.primaryShape;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new RTPortFigure();
        return this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        Dimension defaultSize = this.getDefaultSize();
        RoundedRectangleNodePlateFigure figure = new RoundedRectangleNodePlateFigure(defaultSize);
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        int w = width > defaultSize.width() ? width : defaultSize.width();
        int h = height > defaultSize.height() ? height : defaultSize.height();
        figure.getBounds().setSize(w, h);
        figure.setDefaultSize(w, h);
        return figure;
    }

    protected void refreshVisuals() {
        boolean stack = false;
        if (this.hasNotationView() && this.getUMLElement() != null && RTPropertyUtils.isReplicated((Property)((Property)this.getUMLElement()))) {
            stack = true;
        }
        this.getPrimaryShape().setStack(stack);
        this.getPrimaryShape().setLayerNumber(1);
        this.getPrimaryShape().setXOffSet(2.0);
        this.getPrimaryShape().setYOffSet(2.0);
        this.getPrimaryShape().setLayerOpacity(0);
        this.getPrimaryShape().repaint();
        super.refreshVisuals();
    }

    protected void refreshBackgroundColor() {
        super.refreshBackgroundColor();
        UMLRTEditPartUtils.updateBackgroundColor(this, (NodeFigure)this.getPrimaryShape());
    }

    protected void refreshForegroundColor() {
        super.refreshForegroundColor();
        UMLRTEditPartUtils.updateForegroundColor(this, (Figure)this.getPrimaryShape());
    }

    @Override
    public boolean isPortOnPart() {
        return false;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new RTPortResizableEditPolicy();
    }

    private void reificationStateChanged(UMLRTNamedElement element, boolean reified) {
        if (reified) {
            UMLRTCommandUtils.isUndoRedoInProgress((Notifier)element.toUML());
        }
    }
}

