/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.BorderItemHelper;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTEditPartUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPortKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class RTSideAffixedNodesCreationEditPolicy
extends SideAffixedNodesCreationEditPolicy {
    private final BorderItemHelper<Port> portHelper = new BorderItemHelper<Port>(Port.class, this::getGraphicalHost, this::getPositionLocator);

    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        ICommand result;
        if (request instanceof CreateViewAndElementRequest) {
            UMLRTPortKind portKind = this.getPortKind((CreateViewAndElementRequest)request);
            if (portKind == null) {
                result = super.getSetBoundsCommand(request, descriptor);
            } else {
                switch (portKind) {
                    case INTERNAL_BEHAVIOR: 
                    case SAP: {
                        result = this.getBasicSetBoundsCommand(request, descriptor);
                        break;
                    }
                    default: {
                        result = this.portHelper.getSetBoundsCommand(request, descriptor, IRTPortEditPart.getDefaultSize(this.getHostCapsulePart().isPresent()));
                        break;
                    }
                }
            }
        } else {
            result = this.portHelper.getSetBoundsCommand(request, descriptor, port -> this.getHostCapsulePart().filter(__ -> RTPortUtils.isRTPort((EObject)port)).map(__ -> IRTPortEditPart.getDefaultSize(true)), (r, d) -> this.portHelper.getSetBoundsCommand((CreateViewRequest)r, (CreateViewRequest.ViewDescriptor)d, IRTPortEditPart.getDefaultSize(this.getHostCapsulePart().isPresent())));
        }
        return result;
    }

    private ICommand getBasicSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Point location = this.getLocation((CreateRequest)request);
        this.getHostFigure().translateToRelative((Translatable)location);
        Rectangle bounds = new Rectangle(location, IRTPortEditPart.getDefaultSize(this.getHostCapsulePart().isPresent()));
        Rectangle parentBounds = this.getHostFigure().getBounds().getCopy();
        bounds.translate(parentBounds.getLocation().getNegated());
        return new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)descriptor, bounds);
    }

    private Point getLocation(CreateRequest request) {
        Map params = request.getExtendedData();
        Point realLocation = (Point)params.get("initialMouseLocationForCreation");
        Point result = realLocation != null ? realLocation.getCopy() : request.getLocation().getCopy();
        return result;
    }

    protected Optional<Property> getHostCapsulePart() {
        return Optional.ofNullable(this.getHost().getModel()).filter(View.class::isInstance).map(View.class::cast).map(View::getElement).filter(Property.class::isInstance).map(Property.class::cast).filter(CapsulePartUtils::isCapsulePart);
    }

    protected Point getParamLocation(CreateViewRequest request) {
        Map params = request.getExtendedData();
        Point realLocation = (Point)params.get("initialMouseLocationForCreation");
        return realLocation;
    }

    protected PortPositionLocator getPositionLocator() {
        return this.portHelper.getPositionLocator(this::getScaleFactor, () -> new RTPortPositionLocator(null, this.getHostFigure(), 0, IRTPortEditPart.getDefaultScaleFactor(this.getHostCapsulePart().isPresent())));
    }

    private OptionalDouble getScaleFactor(Port port) {
        return RTPortUtils.isRTPort((EObject)port) ? OptionalDouble.of(IRTPortEditPart.getDefaultScaleFactor(this.getHostCapsulePart().isPresent())) : OptionalDouble.empty();
    }

    protected IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        Command result = null;
        if (this.getHostCapsulePart().isPresent()) {
            result = this.getCreatePortOnPartAndViewCommand(request);
        } else {
            UMLRTPortKind portKind = this.getPortKind(request);
            if (portKind == null) {
                result = EditPartInheritanceUtils.getCreateElementAndViewCommand((IGraphicalEditPart)this.getHost(), request, arg_0 -> ((RTSideAffixedNodesCreationEditPolicy)this).getCreateCommand(arg_0));
            } else {
                switch (portKind) {
                    case EXTERNAL_BEHAVIOR: 
                    case RELAY: 
                    case SPP: {
                        result = !this.isInInterior((CreateRequest)request) ? super.getCreateElementAndViewCommand(request) : UnexecutableCommand.INSTANCE;
                        break;
                    }
                    case INTERNAL_BEHAVIOR: 
                    case SAP: {
                        result = this.isInInterior((CreateRequest)request) ? super.getCreateElementAndViewCommand(request) : UnexecutableCommand.INSTANCE;
                        break;
                    }
                    default: {
                        result = UnexecutableCommand.INSTANCE;
                    }
                }
            }
        }
        return result;
    }

    boolean isInInterior(CreateRequest request) {
        Rectangle bounds = this.getHostFigure().getBounds();
        Point location = this.getLocation(request);
        this.getHostFigure().getParent().translateToRelative((Translatable)location);
        Rectangle interior = bounds.getShrinked(10, 10);
        return interior.contains(location);
    }

    private UMLRTPortKind getPortKind(CreateViewAndElementRequest request) {
        IElementType typeToCreate = (IElementType)request.getViewAndElementDescriptor().getElementAdapter().getAdapter(IElementType.class);
        return RTPortUtils.getPortKind((IElementType)typeToCreate);
    }

    protected Command getCreatePortOnPartAndViewCommand(CreateViewAndElementRequest request) {
        Command result;
        CreateElementRequestAdapter createElement = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        IHintedType portType = (IHintedType)createElement.getAdapter(IElementType.class);
        UMLRTPortKind portKind = RTPortUtils.getPortKind((IElementType)portType);
        if (portKind == null) {
            result = super.getCreateElementAndViewCommand(request);
        } else {
            switch (portKind) {
                case EXTERNAL_BEHAVIOR: 
                case RELAY: 
                case SPP: {
                    result = !this.isInInterior((CreateRequest)request) ? this.getCreatePortOnPartAndViewCommand(request, portType) : UnexecutableCommand.INSTANCE;
                    break;
                }
                default: {
                    result = super.getCreateElementAndViewCommand(request);
                }
            }
        }
        return result;
    }

    private Command getCreatePortOnPartAndViewCommand(final CreateViewAndElementRequest request, IHintedType portType) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        Optional<EncapsulatedClassifier> capsule = this.getPartCapsuleType();
        Optional<View> capsuleView = this.findCapsuleView(capsule);
        if (capsuleView.isPresent()) {
            TransactionalEditingDomain domain = this.getGraphicalHost().getEditingDomain();
            CompositeTransactionalCommand composite = new CompositeTransactionalCommand(domain, "Create Port");
            ICommand createPort = null;
            CreateElementRequest semanticRequest = new CreateElementRequest((EObject)capsule.get(), (IElementType)portType, UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_ATTRIBUTE);
            IElementEditService edit = ElementEditServiceUtils.getCommandProvider((EObject)((EObject)capsule.get()));
            if (edit != null) {
                createPort = edit.getEditCommand((IEditCommandRequest)semanticRequest);
            }
            if (createPort != null && createPort.canExecute()) {
                final ICommand _createPort = createPort;
                composite.add((IUndoableOperation)new AbstractCommand(createPort.getLabel()){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        _createPort.execute(progressMonitor, info);
                        Port createdPort = (Port)TypeUtils.as((Object)_createPort.getCommandResult().getReturnValue(), Port.class);
                        if (createdPort != null) {
                            request.getViewAndElementDescriptor().getCreateElementRequestAdapter().setNewElement((EObject)createdPort);
                            UMLRTEditPartUtils.scheduleDirectEdit(RTSideAffixedNodesCreationEditPolicy.this.getHost(), (EObject)createdPort);
                        }
                        return _createPort.getCommandResult();
                    }

                    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        _createPort.undo(progressMonitor, info);
                        return _createPort.getCommandResult();
                    }

                    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        _createPort.redo(progressMonitor, info);
                        return _createPort.getCommandResult();
                    }
                });
                CreateElementRequestAdapter semanticAdapter = new CreateElementRequestAdapter(semanticRequest);
                CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)semanticAdapter, Node.class, "Port_Shape", true, request.getViewAndElementDescriptor().getPreferencesHint());
                CreateViewCommand createView = new CreateViewCommand(domain, descriptor, capsuleView.get());
                composite.add((IUndoableOperation)createView);
                if (createView.canExecute()) {
                    SetBoundsCommand setBounds = new SetBoundsCommand(domain, "Port Location", (IAdaptable)descriptor, this.getRelativeBounds(this.getLocation((CreateRequest)request), capsuleView.get()));
                    composite.add((IUndoableOperation)setBounds);
                }
            }
            result = new ICommandProxy(composite.reduce());
        }
        return result;
    }

    protected IGraphicalEditPart getGraphicalHost() {
        return (IGraphicalEditPart)this.getHost();
    }

    protected Optional<EncapsulatedClassifier> getPartCapsuleType() {
        return Optional.ofNullable(this.getGraphicalHost()).map(IGraphicalEditPart::resolveSemanticElement).filter(Property.class::isInstance).map(Property.class::cast).map(TypedElement::getType).filter(EncapsulatedClassifier.class::isInstance).map(EncapsulatedClassifier.class::cast);
    }

    protected Optional<View> findCapsuleView(Optional<EncapsulatedClassifier> capsule) {
        return capsule.filter(Class.class::isInstance).map(Class.class::cast).map(UMLRTCapsuleStructureDiagramUtils::getCapsuleStructureDiagram).map(d -> ViewUtil.getChildBySemanticHint((View)d, (String)"Class_Shape"));
    }

    protected Rectangle getRelativeBounds(Point mouse, View capsuleView) {
        Rectangle result = new Rectangle(mouse.getCopy(), IRTPortEditPart.getDefaultSize(false));
        IFigure partFigure = this.getHostFigure();
        partFigure.translateToRelative((Translatable)result);
        Rectangle partBounds = partFigure.getBounds().getCopy();
        result.translate(partBounds.getLocation().getNegated());
        Bounds capsuleBounds = (Bounds)TypeUtils.as((Object)((Node)capsuleView).getLayoutConstraint(), Bounds.class);
        if (capsuleBounds != null) {
            result.setSize(IRTPortEditPart.getDefaultSize(true));
            RelativePortLocation relative = RelativePortLocation.of(result, partBounds);
            result.setSize(IRTPortEditPart.getDefaultSize(false));
            result.setLocation(relative.applyTo(new Rectangle(capsuleBounds.getX(), capsuleBounds.getY(), capsuleBounds.getWidth(), capsuleBounds.getHeight()), result.getSize()));
            result.translate(result.width() / 2, result.height() / 2);
        }
        return result;
    }
}

