/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.CanLayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNodesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeProvider;
import org.eclipse.gmf.runtime.notation.View;

public class PrivateLayoutService
extends Service
implements ILayoutNodeProvider {
    public static final PrivateLayoutService INSTANCE = new PrivateLayoutService();

    public PrivateLayoutService(List<? extends ILayoutNodeProvider> providers) {
        providers.forEach(this::addProvider);
    }

    public PrivateLayoutService(ILayoutNodeProvider provider, ILayoutNodeProvider ... more) {
        this(Lists.asList((Object)provider, (Object[])more));
    }

    private PrivateLayoutService() {
        ArrayList configs = Lists.newArrayList((Object[])Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.gmf.runtime.diagram.ui", "layoutProviders").getConfigurationElements());
        configs.removeIf(c -> c.getContributor().getName().startsWith("org.eclipse.elk"));
        this.configureProviders(configs.toArray(new IConfigurationElement[configs.size()]));
    }

    private void addProvider(ILayoutNodeProvider theProvider) {
        this.addProvider(ProviderPriority.HIGHEST, new Service.ProviderDescriptor(null, theProvider){
            {
                this.policyInitialized = true;
                this.provider = iLayoutNodeProvider;
            }
        });
    }

    private Object execute(IOperation operation) {
        List results = this.execute(ExecutionStrategy.FIRST, operation);
        return results.isEmpty() ? null : results.get(0);
    }

    private void checkValidLayoutNodes(List<?> nodes) {
        if (nodes == null) {
            throw new NullPointerException("Argument 'nodes' is null");
        }
        if (nodes.size() == 0) {
            throw new IllegalArgumentException("Argument 'nodes' is empty");
        }
        View parent = null;
        for (Object next : nodes) {
            if (!(next instanceof ILayoutNode)) {
                throw new IllegalArgumentException("Argument 'nodes' contains objects which aren't of type 'ILayoutNode'");
            }
            ILayoutNode node = (ILayoutNode)next;
            if (parent == null) {
                parent = ViewUtil.getContainerView((View)node.getNode());
                continue;
            }
            if (ViewUtil.getContainerView((View)node.getNode()) == parent) continue;
            throw new IllegalArgumentException("Argument 'nodes' contains objects which have a different parent containment");
        }
    }

    public Runnable layoutLayoutNodes(List layoutNodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        if (layoutHint == null) {
            throw new NullPointerException("Argument 'layoutHint' is null");
        }
        this.checkValidLayoutNodes(layoutNodes);
        Assert.isNotNull((Object)layoutNodes);
        Assert.isNotNull((Object)layoutHint);
        return (Runnable)this.execute((IOperation)new LayoutNodesOperation(layoutNodes, offsetFromBoundingBox, layoutHint));
    }

    public boolean canLayoutNodes(List layoutNodes, boolean shouldOffsetFromBoundingBox, IAdaptable layoutHint) {
        return this.execute((IOperation)new CanLayoutNodesOperation(layoutNodes, shouldOffsetFromBoundingBox, layoutHint)) == Boolean.TRUE;
    }
}

