/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.migration;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.infra.gmfdiag.style.StyleFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;
import org.eclipse.papyrus.infra.viewpoints.style.StylePackage;
import org.eclipse.papyrusrt.umlrt.core.Activator;

public class DiagramMigrationSnippet
implements IModelSetSnippet {
    public static final String LEGACY_STRUCTURE_CONFIGURATION = "org.eclipse.papyrusrt.umlrt.tooling.diagram.common/configuration/UMLRT.configuration";
    public static final String LEGACY_STATEMACHINE_CONFIGURATION = "org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine/configuration/RTStateMachine.configuration";
    public static final String LEGACY_STRUCTURE_FRAGMENT = "_Z79eQHcZEeSnWeKqQOfW2A";
    public static final String LEGACY_STATEMACHINE_FRAGMENT = "_Z79eQHcZEeSnWeKqQOfW2A";
    public static final URI LEGACY_STRUCTURE_URI = URI.createPlatformPluginURI((String)"org.eclipse.papyrusrt.umlrt.tooling.diagram.common/configuration/UMLRT.configuration", (boolean)true).appendFragment("_Z79eQHcZEeSnWeKqQOfW2A");
    public static final URI LEGACY_STATEMACHINE_URI = URI.createPlatformPluginURI((String)"org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine/configuration/RTStateMachine.configuration", (boolean)true).appendFragment("_Z79eQHcZEeSnWeKqQOfW2A");
    public static final String STRUCTURE_ID = "org.eclipse.papyrusrt.umlrt.tooling.diagram.common.UMLRTCapsuleStructure";
    public static final String STATEMACHINE_ID = "org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.UMLRTStateMachine";

    public void start(ModelSet modelsManager) {
        ILanguageService service;
        try {
            service = (ILanguageService)ServiceUtilsForResourceSet.getInstance().getService(ILanguageService.class, (Object)modelsManager);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return;
        }
        if (service.getLanguages(modelsManager).stream().anyMatch(l -> "org.eclipse.papyrusrt.umlrt.core.language".equals(l.getID()))) {
            ArrayList allDiagrams = new ArrayList();
            NotationUtils.getAllNotations((ResourceSet)modelsManager).forEach(allDiagrams::add);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((ResourceSet)modelsManager);
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, () -> allDiagrams.stream().filter(e -> e instanceof Diagram).map(e -> (Diagram)e).forEach(this::migrateDiagram));
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
            catch (RollbackException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private void migrateDiagram(Diagram diagram) {
        Style style = diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
        if (style instanceof PapyrusViewStyle) {
            PapyrusViewStyle legacyViewpointStyle = (PapyrusViewStyle)style;
            PapyrusView configuration = legacyViewpointStyle.getConfiguration();
            if (configuration == null) {
                return;
            }
            URI viewpointURI = EcoreUtil.getURI((EObject)configuration);
            String representationID = LEGACY_STRUCTURE_URI.equals(viewpointURI) ? STRUCTURE_ID : (LEGACY_STATEMACHINE_URI.equals(viewpointURI) ? STATEMACHINE_ID : null);
            if (representationID != null) {
                PapyrusDiagramStyle newViewpointStyle = StyleFactory.eINSTANCE.createPapyrusDiagramStyle();
                newViewpointStyle.setDiagramKindId(representationID);
                newViewpointStyle.setOwner(legacyViewpointStyle.getOwner());
                diagram.getStyles().remove((Object)legacyViewpointStyle);
                diagram.getStyles().add((Object)newViewpointStyle);
            }
        }
    }

    public void dispose(ModelSet modelsManager) {
    }
}

