/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.migration;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler_1_3_0;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public class UMLRTDiagramReconciler130
extends DiagramReconciler_1_3_0 {
    private static final String CAPSULE_STRUCTURE_DIAGRAM_OLD_TYPE = "CompositeStructure";
    private static final String STATE_MACHINE_DIAGRAM_OLD_TYPE = "PapyrusUMLStateMachineDiagram";
    private static final String CAPSULE_STRUCTURE_DIAGRAM_OLD_NAME = "UML-RT Capsule Structure Diagram";
    private static final String STATE_MACHINE_DIAGRAM_OLD_NAME = "UML-RT State Machine Diagram";

    protected PapyrusDiagram getDiagramKind(Diagram diagram, PapyrusViewStyle oldStyle) {
        org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram oldDiagramKind;
        if (oldStyle != null && (oldDiagramKind = (org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram)oldStyle.getConfiguration()) != null) {
            String name = oldDiagramKind.getName();
            if (name == null) {
                name = this.getNameByURI(oldDiagramKind);
            }
            return this.getDiagramKind(name, diagram);
        }
        if (CAPSULE_STRUCTURE_DIAGRAM_OLD_TYPE.equals(diagram.getType())) {
            return this.getDiagramKind(CAPSULE_STRUCTURE_DIAGRAM_OLD_NAME, diagram);
        }
        if (STATE_MACHINE_DIAGRAM_OLD_TYPE.equals(diagram.getType())) {
            return this.getDiagramKind(STATE_MACHINE_DIAGRAM_OLD_NAME, diagram);
        }
        return null;
    }

    protected String getNameByURI(org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram oldDiagramKind) {
        if (oldDiagramKind instanceof MinimalEObjectImpl) {
            URI uri = ((MinimalEObjectImpl)oldDiagramKind).eProxyURI();
            String uri2String = uri.toString();
            if ("platform:/plugin/org.eclipse.papyrusrt.umlrt.tooling.diagram.common/configuration/UMLRT.configuration#_Z79eQHcZEeSnWeKqQOfW2A".equals(uri2String)) {
                return CAPSULE_STRUCTURE_DIAGRAM_OLD_NAME;
            }
            if ("platform:/plugin/org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine/configuration/RTStateMachine.configuration#_Z79eQHcZEeSnWeKqQOfW2A".equals(uri2String)) {
                return STATE_MACHINE_DIAGRAM_OLD_NAME;
            }
        }
        return null;
    }

    protected PapyrusDiagram getDiagramKind(String name, Diagram diagram) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureDescriptionLanguage context = (MergedArchitectureDescriptionLanguage)manager.getArchitectureContextById("org.eclipse.papyrusrt.umlrt.architecture");
        for (RepresentationKind pKind : context.getRepresentationKinds()) {
            if (!pKind.getName().equals(name)) continue;
            PapyrusDiagram dKind = (PapyrusDiagram)pKind;
            return dKind;
        }
        return null;
    }
}

