/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.types.advice;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;

public class DeleteInheritedViewsAdvice
extends AbstractEditHelperAdvice {
    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = request instanceof ExcludeDependentsRequest ? this.getBeforeExcludeDependentsCommand((ExcludeDependentsRequest)request) : super.getBeforeEditCommand(request);
        return result;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ICommand result = null;
        EObject destructee = request.getElementToDestroy();
        if (destructee instanceof Element) {
            result = this.getBeforeDestroyDependentsCommand(request, (Element)destructee);
        }
        return result;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request, Element destructee) {
        Optional<Element> inherited = Optional.of(destructee).map(UMLRTExtensionUtil::getRootDefinition);
        Stream<View> views = inherited.map(this::getViews).orElseGet(Stream::empty).filter(v -> {
            EObject semantic = EditPartInheritanceUtils.resolveSemanticElement(v);
            return semantic != destructee && semantic instanceof Element && UMLRTExtensionUtil.redefines((Element)((Element)semantic), (Element)destructee);
        });
        ICommand result = views.map(arg_0 -> ((DestroyDependentsRequest)request).getDestroyDependentCommand(arg_0)).filter(Objects::nonNull).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
        return result;
    }

    Stream<View> getViews(Element element) {
        return EMFHelper.getUsages((EObject)element).stream().filter(s -> s.getEStructuralFeature() == NotationPackage.Literals.VIEW__ELEMENT).map(EStructuralFeature.Setting::getEObject).map(View.class::cast).filter(v -> v.eResource() != null);
    }

    protected ICommand getBeforeExcludeDependentsCommand(ExcludeDependentsRequest request) {
        ICommand result = null;
        if (!request.isExclude()) {
            Stream<Element> locals = request.getElementToExclude().allOwnedElements().stream().filter(((Predicate<Element>)UMLRTExtensionUtil::isInherited).negate());
            Stream<ICommand> views = locals.flatMap(this::getViews);
            result = views.map(v -> this.getDestroyViewCommand(request, (View)v)).filter(Objects::nonNull).reduce(UMLRTCommandUtils::flatCompose).orElse(null);
            Diagram diagram = UMLRTCapsuleStructureDiagramUtils.getDiagram((EObject)request.getElementToExclude(), null);
            if (diagram != null) {
                result = UMLRTCommandUtils.flatCompose((ICommand)result, (ICommand)this.getDestroyViewCommand(request, (View)diagram));
            }
        }
        return result;
    }

    protected ICommand getDestroyViewCommand(ExcludeDependentsRequest request, View view) {
        ICommand result = null;
        IElementType type = ElementTypeRegistry.getInstance().getElementType((EObject)view, request.getClientContext());
        if (type != null) {
            DestroyElementRequest destroy = new DestroyElementRequest(request.getEditingDomain(), (EObject)view, false);
            destroy.setClientContext(request.getClientContext());
            result = type.getEditCommand((IEditCommandRequest)destroy);
        }
        return result;
    }
}

