/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrusrt.umlrt.core.internal.commands.CreateHeadlessStateMachineDiagramCommand;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTCapsuleStructureDiagramUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLRTStateMachineDiagramUtils {
    private static final String STATE_NAME_SEPARATOR = "..";
    private static final UMLSwitch<String> separatorSwitch = new UMLSwitch<String>(){

        public String caseNamedElement(NamedElement object) {
            return "::";
        }

        public String caseState(State object) {
            return UMLRTStateMachineDiagramUtils.STATE_NAME_SEPARATOR;
        }

        public String defaultCase(EObject object) {
            return "::";
        }
    };
    private static final UMLSwitch<BehavioredClassifier> contextSwitch = new UMLSwitch<BehavioredClassifier>(){

        public BehavioredClassifier caseBehavior(Behavior object) {
            return object.getContext();
        }

        public BehavioredClassifier caseVertex(Vertex object) {
            return Optional.of(object).map(Vertex::containingStateMachine).map(arg_0 -> (this).doSwitch(arg_0)).orElse(null);
        }

        public BehavioredClassifier defaultCase(EObject object) {
            return null;
        }
    };

    public static boolean isRTStateMachineDiagram(Diagram diagram) {
        if (diagram == null) {
            return false;
        }
        if ("PapyrusUMLStateMachineDiagram".equals(diagram.getType())) {
            EObject businessElement = diagram.getElement();
            return businessElement instanceof StateMachine && StateMachineUtils.isRTStateMachine((StateMachine)((StateMachine)businessElement)) || businessElement instanceof State && StateUtils.isRTState((State)((State)businessElement));
        }
        return false;
    }

    public static String getDisplayedDiagramName(Diagram diagram) {
        EObject businessElement = diagram.getElement();
        if (!Strings.isNullOrEmpty((String)diagram.getName())) {
            return diagram.getName();
        }
        StringBuilder result = new StringBuilder();
        Optional<String> context = Optional.ofNullable((BehavioredClassifier)contextSwitch.doSwitch(businessElement)).map(NamedElement::getName).filter(name -> !Strings.isNullOrEmpty((String)name));
        if (context.isPresent()) {
            result.append(context.get());
            NamedElement element = (NamedElement)businessElement;
            if (!Strings.isNullOrEmpty((String)element.getName())) {
                if (result.length() > 0) {
                    result.append((String)separatorSwitch.doSwitch((EObject)element));
                }
                result.append(element.getName());
            }
            return result.length() > 0 ? result.toString() : "<error>";
        }
        return diagram.getName();
    }

    public static Diagram createStateMachineDiagram(EObject context, String name) {
        Diagram result = null;
        try {
            ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(context);
            ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
            ViewPrototype prototype = UMLRTStateMachineDiagramUtils.getPrototype(modelSet, context);
            if (prototype != null) {
                result = new CreateHeadlessStateMachineDiagramCommand().createDiagram(modelSet, context, context, prototype, name, false);
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return result;
    }

    private static ViewPrototype getPrototype(ModelSet modelSet, EObject context) {
        Diagram diagram;
        ViewPrototype prototype;
        Element owner;
        List diagrams;
        Region container;
        if (context instanceof State && (container = ((State)context).getContainer()) != null && (diagrams = DiagramUtils.getAssociatedDiagrams((EObject)(owner = container.getOwner()), (ResourceSet)modelSet)) != null && !diagrams.isEmpty() && (prototype = DiagramUtils.getPrototype((Diagram)(diagram = (Diagram)diagrams.get(0)))) != null) {
            return prototype;
        }
        Collection prototypes = PolicyChecker.getFor((EObject)context).getPrototypesFor(context);
        for (ViewPrototype prototype2 : prototypes) {
            PapyrusRepresentationKind kind = prototype2.getRepresentationKind();
            if (kind == null || !"UML-RT State Machine Diagram".equals(kind.getName())) continue;
            return prototype2;
        }
        return null;
    }

    public static Diagram getStateMachineDiagram(StateMachine stateMachine) {
        return UMLRTCapsuleStructureDiagramUtils.getDiagram((EObject)stateMachine, UMLRTStateMachineDiagramUtils::isRTStateMachineDiagram);
    }

    public static Diagram getStateMachineDiagram(State state) {
        return UMLRTCapsuleStructureDiagramUtils.getDiagram((EObject)state, UMLRTStateMachineDiagramUtils::isRTStateMachineDiagram);
    }
}

