/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.helper.EditorHyperLinkHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.RegionUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateNestedStateMachineDiagramCommand
extends AbstractTransactionalCommand {
    private final State state;
    private final IGraphicalEditPart stateEditPart;
    private final boolean openDiagram;
    private Diagram createdDiagram;

    public CreateNestedStateMachineDiagramCommand(TransactionalEditingDomain domain, State state, IGraphicalEditPart stateEditPart, boolean openDiagram) {
        super(domain, "Create State Machine Diagram", CreateNestedStateMachineDiagramCommand.getWorkspaceFiles(Arrays.asList(state, stateEditPart.getNotationView())));
        this.state = state;
        this.stateEditPart = stateEditPart;
        this.openDiagram = openDiagram;
    }

    public void dispose() {
        this.createdDiagram = null;
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View stateView = this.stateEditPart.getNotationView();
        UMLRTState facade = UMLRTState.getInstance((State)this.state);
        if (facade == null) {
            return CommandResult.newErrorCommandResult((String)"Cannot redefine state");
        }
        facade.reify();
        UMLRTExtensionUtil.getUMLRTContents((EObject)this.state, (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]).stream().forEach(UMLRTExtensionUtil::touch);
        this.createdDiagram = UMLRTStateMachineDiagramUtils.createStateMachineDiagram((EObject)this.state, null);
        if (this.createdDiagram != null) {
            EditorHyperLinkHelper helper;
            Command hyperlink;
            UMLRTExtensionUtil.getUMLRTContents((EObject)this.state, (EStructuralFeature)UMLPackage.Literals.STATE__REGION, (EStructuralFeature[])new EStructuralFeature[0]).forEach(RegionUtils::applyStereotype);
            if (this.openDiagram) {
                CommandResult[] failure = new CommandResult[1];
                try {
                    GMFUnsafe.write((TransactionalEditingDomain)this.getEditingDomain(), () -> {
                        try {
                            IPageManager pages = ServiceUtilsForEObject.getInstance().getIPageManager((Object)this.createdDiagram);
                            pages.openPage((Object)this.createdDiagram);
                        }
                        catch (ServiceException e) {
                            commandResultArray[0] = CommandResult.newErrorCommandResult((Throwable)e);
                        }
                    });
                }
                catch (Exception e) {
                    failure[0] = CommandResult.newErrorCommandResult((Throwable)e);
                }
                if (failure[0] != null) {
                    return failure[0];
                }
            }
            if ((hyperlink = (helper = new EditorHyperLinkHelper()).getCreateHyperlinkCommand(this.getEditingDomain(), (EModelElement)stateView, (Object)this.createdDiagram)) != null && hyperlink.canExecute()) {
                hyperlink.execute();
            }
        }
        return this.createdDiagram == null ? CommandResult.newCancelledCommandResult() : CommandResult.newOKCommandResult((Object)this.createdDiagram);
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result;
        IStatus[] failure = new IStatus[1];
        if (this.createdDiagram != null) {
            try {
                GMFUnsafe.write((TransactionalEditingDomain)this.getEditingDomain(), () -> {
                    try {
                        IPageManager pages = ServiceUtilsForEObject.getInstance().getIPageManager((Object)this.createdDiagram);
                        if (pages.isOpen((Object)this.createdDiagram)) {
                            pages.closeAllOpenedPages((Object)this.createdDiagram);
                            if (Display.getCurrent() != null) {
                                DisplayUtils.clearEventLoop();
                            }
                        }
                    }
                    catch (ServiceException e) {
                        iStatusArray[0] = CommandResult.newErrorCommandResult((Throwable)e).getStatus();
                    }
                });
            }
            catch (Exception e) {
                failure[0] = CommandResult.newErrorCommandResult((Throwable)e).getStatus();
            }
        }
        if (((result = super.doUndo(monitor, info)) == null || result.getSeverity() < 4) && failure[0] != null && failure[0].getSeverity() >= 4) {
            result = failure[0];
        }
        return result;
    }
}

