/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomRegionEditPart;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.Either;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.RTSemanticEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IStateMachineInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPartTN;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.UMLPackage;

public class RTRegionEditPart
extends CustomRegionEditPart
implements IStateMachineInheritableEditPart {
    private Adapter redefinitionAdapter;

    public RTRegionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new RTSemanticEditPolicy());
    }

    public EObject resolveSemanticElement() {
        return EditPartInheritanceUtils.resolveSemanticElement((IInheritableEditPart)this, (EObject)super.resolveSemanticElement());
    }

    public Object getAdapter(Class key) {
        return EditPartInheritanceUtils.getAdapter((IGraphicalEditPart)this, (Class)key, (Object)super.getAdapter(key));
    }

    public boolean isSemanticInherited() {
        EObject semantic = this.resolveSemanticElement();
        return semantic instanceof Region && UMLRTExtensionUtil.isInherited((Element)((Region)semantic));
    }

    public Optional<UMLRTNamedElement> getUMLRTElement() {
        Optional<UMLRTNamedElement> result = Optional.empty();
        EObject semantic = this.resolveSemanticElement();
        if (semantic instanceof Region) {
            Region region = (Region)semantic;
            result = Optional.ofNullable((NamedElement)Either.or((Object)region.getStateMachine(), (Object)region.getState()).orElse(NamedElement.class, null)).map(UMLRTFactory::create);
        }
        return result;
    }

    @Override
    public UMLRTNamedElement getRedefinitionContext(UMLRTNamedElement element) {
        Predicate<UMLRTNamedElement> same = element::equals;
        Predicate<UMLRTNamedElement> redefinition = e -> e.redefines(element);
        return this.getUMLRTElement().filter(same.or(redefinition)).map(__ -> element).orElseGet(() -> (UMLRTNamedElement)EditPartInheritanceUtils.getStateMachineContext((UMLRTNamedElement)element).getEither(UMLRTNamedElement.class));
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        Region region = (Region)TypeUtils.as((Object)this.resolveSemanticElement(), Region.class);
        if (region != null && region.getExtendedRegion() == null) {
            region.eAdapters().add((Object)this.getRedefinitionAdapter());
        }
    }

    private Adapter getRedefinitionAdapter() {
        if (this.redefinitionAdapter == null) {
            this.redefinitionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!msg.isTouch() && msg.getFeature() == UMLPackage.Literals.REGION__EXTENDED_REGION) {
                        switch (msg.getEventType()) {
                            case 1: 
                            case 2: {
                                View view;
                                Region root;
                                Region region = (Region)TypeUtils.as((Object)RTRegionEditPart.this.resolveSemanticElement(), Region.class);
                                Region region2 = root = region == null ? region : (Region)UMLRTExtensionUtil.getRootDefinition((Element)region);
                                if (root == null || (view = RTRegionEditPart.this.getNotationView()) == null || view.getElement() == root) break;
                                view.setElement((EObject)root);
                            }
                        }
                    }
                }
            };
        }
        return this.redefinitionAdapter;
    }

    protected void removeSemanticListeners() {
        if (this.redefinitionAdapter != null) {
            Notifier target = this.redefinitionAdapter.getTarget();
            if (target != null) {
                target.eAdapters().remove((Object)this.redefinitionAdapter);
            }
            this.redefinitionAdapter = null;
        }
        super.removeSemanticListeners();
    }

    protected void handleNotificationEvent(Notification notification2) {
        EditPartInheritanceUtils.handleNotificationEvent((IGraphicalEditPart)this, (Notification)notification2, notification -> super.handleNotificationEvent(notification));
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart result;
        if (request instanceof CreateViewAndElementRequest) {
            Optional<IElementType> elementType = Optional.of(request).map(CreateViewAndElementRequest.class::cast).map(CreateViewAndElementRequest::getViewAndElementDescriptor).map(CreateViewRequest.ViewDescriptor::getElementAdapter).map(a -> (IElementType)a.getAdapter(IElementType.class));
            result = elementType.map(type -> ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_ENTRY_POINT) || ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_EXIT_POINT) || ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLRTElementTypesEnumerator.TRANSITION_INTERNAL) ? (EditPart)TypeUtils.as((Object)this.getParent().getParent(), RTStateEditPartTN.class) : (ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLElementTypes.STATE) || ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLElementTypes.PSEUDOSTATE) ? this.getChildBySemanticHint("Region_SubvertexCompartment") : null)).orElseGet(() -> super.getTargetEditPart(request));
        } else {
            result = super.getTargetEditPart(request);
        }
        return result;
    }
}

