/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedToolTipLabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.services.labelprovider.service.ExtensibleLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.TransitionNameEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies.InheritanceEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IStateMachineInheritableEditPart;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;

public class RTTransitionNameEditPart
extends TransitionNameEditPart
implements IStateMachineInheritableEditPart {
    private static final String UMLRT_ROOT_FILTER = "umlrtRoot";
    private Label toolTipLabel = new Label();

    public RTTransitionNameEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("umlrtInheritance", (EditPolicy)new InheritanceEditPolicy());
        super.createDefaultEditPolicies();
    }

    public EObject resolveSemanticElement() {
        return EditPartInheritanceUtils.resolveSemanticElement((IInheritableEditPart)this, (EObject)super.resolveSemanticElement());
    }

    public Object getAdapter(Class key) {
        return EditPartInheritanceUtils.getAdapter((IGraphicalEditPart)this, (Class)key, (Object)super.getAdapter(key));
    }

    protected Image getLabelIcon() {
        EObject parserElement = this.getParserElement();
        if (parserElement == null || this.getViewer() == null && parserElement.eResource() != null) {
            return null;
        }
        List views = DiagramEditPartsUtil.findViews((EObject)parserElement, (EditPartViewer)this.getViewer());
        for (View view : views) {
            if (!AppearanceHelper.showElementIcon((EModelElement)view)) continue;
            try {
                return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)parserElement)).getLabelProvider().getImage((Object)parserElement);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected void addSemanticListeners() {
        Element element;
        Element root;
        super.addSemanticListeners();
        EObject semantic = this.resolveSemanticElement();
        if (semantic instanceof Element && (root = UMLRTExtensionUtil.getRootDefinition((Element)(element = (Element)semantic))) != null && root != element) {
            this.addListenerFilter(UMLRT_ROOT_FILTER, (NotificationListener)this, (EObject)root);
        }
    }

    protected void removeSemanticListeners() {
        this.removeListenerFilter(UMLRT_ROOT_FILTER);
        super.removeSemanticListeners();
    }

    protected void handleNotificationEvent(Notification event) {
        ISemanticParser modelParser;
        super.handleNotificationEvent(event);
        if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
            this.refreshLabel();
        }
        if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
            this.removeSemanticListeners();
            if (this.resolveSemanticElement() != null) {
                this.addSemanticListeners();
            }
            this.refreshLabel();
        }
    }

    protected void refreshLabel() {
        View view = (View)this.getModel();
        if (view.isVisible() && view.getElement() != null && view.getElement().eResource() != null) {
            super.refreshLabel();
            this.getFigure().setToolTip(this.getLabelToolTip());
        }
    }

    protected IFigure getLabelToolTip() {
        String text = this.getToolTipText();
        if (text != null && text.length() > 0) {
            this.toolTipLabel.setText(text);
            return this.toolTipLabel;
        }
        return null;
    }

    protected String getToolTipText() {
        EObject parserElement = this.getParserElement();
        if (parserElement != null && parserElement.eResource() != null) {
            try {
                ILabelProvider labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)parserElement)).getLabelProvider();
                if (labelProvider instanceof ExtensibleLabelProvider) {
                    Method getProvider = ExtensibleLabelProvider.class.getDeclaredMethod("getProvider", Object.class);
                    getProvider.setAccessible(true);
                    Object result = getProvider.invoke((Object)labelProvider, parserElement);
                    if (result instanceof ICustomizedToolTipLabelProvider) {
                        return ((ICustomizedToolTipLabelProvider)result).getToolTipText((Object)parserElement, null);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | ServiceException e) {
                Activator.log.error(e);
            }
        }
        return null;
    }
}

