/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Compartment;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.command.CreateOrReuseViewCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.EditPartInheritanceUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.CreateNestedStateMachineDiagramCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.RerouteTransitionsToConnectionPointsCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IRTPseudostateEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPartUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.locator.StateBorderItemHelper;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;

class RTStateConnectionPointsCreationEditPolicy
extends SideAffixedNodesCreationEditPolicy {
    private final StateBorderItemHelper<Pseudostate> pseudostateHelper = new StateBorderItemHelper<Pseudostate>(Pseudostate.class, this::getGraphicalHost, this::getPositionLocator);

    IGraphicalEditPart getGraphicalHost() {
        return (IGraphicalEditPart)this.getHost();
    }

    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        return EditPartInheritanceUtils.getCreateElementAndViewCommand((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (CreateViewAndElementRequest)request, this::getCreateCommand);
    }

    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        return this.pseudostateHelper.getSetBoundsCommand(request, descriptor, this::getSize, this::getTypeSize, (createViewRequest, viewDescriptor) -> super.getSetBoundsCommand(createViewRequest, viewDescriptor));
    }

    private Optional<Dimension> getSize(Pseudostate pseudostate) {
        return this.getConnectionPointKind(pseudostate).map(IRTPseudostateEditPart::getDefaultSize);
    }

    private Optional<Dimension> getTypeSize(IElementType type) {
        return this.getConnectionPointType(type).map(IRTPseudostateEditPart::getDefaultSize);
    }

    protected Optional<PseudostateKind> getConnectionPointType(IElementType type) {
        if (ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_EXIT_POINT)) {
            return Optional.of(PseudostateKind.EXIT_POINT_LITERAL);
        }
        if (ElementTypeUtils.isTypeCompatible((IElementType)type, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_ENTRY_POINT)) {
            return Optional.of(PseudostateKind.ENTRY_POINT_LITERAL);
        }
        return Optional.empty();
    }

    protected Optional<PseudostateKind> getConnectionPointKind(Pseudostate pseudostate) {
        Optional<Pseudostate> pseudo = Optional.ofNullable(pseudostate).filter(Pseudostate.class::isInstance).map(Pseudostate.class::cast);
        return pseudo.map(Pseudostate::getKind).filter(k -> k == PseudostateKind.ENTRY_POINT_LITERAL || k == PseudostateKind.EXIT_POINT_LITERAL);
    }

    protected PortPositionLocator getPositionLocator() {
        return this.pseudostateHelper.getPositionLocator(this::getScaleFactor, () -> super.getPositionLocator());
    }

    private OptionalDouble getScaleFactor(Pseudostate pseudostate) {
        return this.getConnectionPointKind(pseudostate).map(kind -> OptionalDouble.of(IRTPseudostateEditPart.getDefaultScaleFactor(kind))).orElseGet(OptionalDouble::empty);
    }

    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            if ("InternalTransition_Label".equals(descriptor.getSemanticHint())) {
                ICommand setBoundsCommand;
                View containerView = (View)this.getHost().getModel();
                Compartment internalTransitionCompartment = RTStateEditPartUtils.getInternalTransitionCompartment(containerView);
                if (internalTransitionCompartment == null) continue;
                State targetState = (State)EditPartInheritanceUtils.resolveSemanticElement((View)containerView);
                if (!targetState.isComposite()) {
                    ICommand composed = RTStateConnectionPointsCreationEditPolicy.getStateAsCompositeCommand(editingDomain, targetState, (IGraphicalEditPart)this.getHost());
                    composed = composed.compose((IUndoableOperation)new CreateOrReuseViewCommand(editingDomain, descriptor, (View)internalTransitionCompartment));
                    setBoundsCommand = this.getSetBoundsCommand(request, descriptor);
                    if (setBoundsCommand != null) {
                        composed = composed.compose((IUndoableOperation)setBoundsCommand);
                    }
                    cc.compose((IUndoableOperation)composed);
                    continue;
                }
                CreateOrReuseViewCommand createCommand = new CreateOrReuseViewCommand(editingDomain, descriptor, (View)internalTransitionCompartment);
                setBoundsCommand = this.getSetBoundsCommand(request, descriptor);
                if (setBoundsCommand != null) {
                    createCommand = CompositeCommand.compose((ICommand)createCommand, (ICommand)setBoundsCommand);
                }
                cc.compose((IUndoableOperation)createCommand);
                continue;
            }
            if ("Region_Shape".equals(descriptor.getSemanticHint())) {
                return UnexecutableCommand.INSTANCE;
            }
            CreateViewCommand createCommand = new CreateViewCommand(editingDomain, descriptor, (View)this.getHost().getModel());
            ICommand setBoundsCommand = this.getSetBoundsCommand(request, descriptor);
            if (setBoundsCommand != null) {
                createCommand = CompositeCommand.compose((ICommand)createCommand, (ICommand)setBoundsCommand);
            }
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    private static ICommand getStateAsCompositeCommand(TransactionalEditingDomain domain, State targetState, IGraphicalEditPart stateEditPart) {
        CreateNestedStateMachineDiagramCommand createDiagram = new CreateNestedStateMachineDiagramCommand(domain, targetState, stateEditPart, false);
        Supplier<Diagram> newDiagram = () -> RTStateConnectionPointsCreationEditPolicy.lambda$2((ICommand)createDiagram);
        CreateNestedStateMachineDiagramCommand composed = createDiagram;
        ICommand rerouteTransitions = RerouteTransitionsToConnectionPointsCommand.createRerouteTransitionsCommand(domain, targetState, stateEditPart);
        if (rerouteTransitions != null) {
            composed = composed.compose((IUndoableOperation)rerouteTransitions);
        }
        composed = composed.compose((IUndoableOperation)RTStateConnectionPointsCreationEditPolicy.getConnectionPointMatchingCommand(domain, targetState, stateEditPart, newDiagram));
        return composed;
    }

    private static ICommand getConnectionPointMatchingCommand(TransactionalEditingDomain domain, final State state, final IGraphicalEditPart stateEP, final Supplier<? extends Diagram> newDiagram) {
        return new AbstractTransactionalCommand(domain, "Arrange Connection Points", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View frame;
                Diagram smd = (Diagram)newDiagram.get();
                View view = frame = smd == null ? null : ViewUtil.getChildBySemanticHint((View)smd, (String)"State_Shape_TN");
                if (frame instanceof Node) {
                    Rectangle frameRect = this.getBounds((Node)frame);
                    Rectangle stateRect = this.getBounds(stateEP);
                    View stateView = stateEP.getNotationView();
                    for (Pseudostate connPt : state.getConnectionPoints()) {
                        Rectangle connPtRect = this.getBounds(this.findChildNode(stateView, (EObject)connPt));
                        RelativePortLocation loc = RelativePortLocation.of((Rectangle)connPtRect, (Rectangle)stateRect);
                        String semanticHint = connPt.getKind() == PseudostateKind.ENTRY_POINT_LITERAL ? "Pseudostate_EntryPointShape" : "Pseudostate_ExitPointShape";
                        Node onFrame = ViewService.getInstance().createNode((IAdaptable)new SemanticAdapter((EObject)connPt, null), frame, semanticHint, -1, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                        Point moveTo = loc.applyTo(frameRect, IRTPseudostateEditPart.getDefaultSize(connPt.getKind()));
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__X, (Object)moveTo.x());
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__Y, (Object)moveTo.y());
                    }
                }
                return CommandResult.newOKCommandResult();
            }

            Rectangle getBounds(IGraphicalEditPart editPart) {
                return editPart.getFigure().getBounds().getCopy();
            }

            Node findChildNode(View parent, EObject element) {
                return parent.getChildren().stream().filter(Node.class::isInstance).map(Node.class::cast).filter(n -> n.getElement() == element).findFirst().get();
            }

            Rectangle getBounds(Node node) {
                Bounds result = (Bounds)node.getLayoutConstraint();
                return new Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
            }
        };
    }

    private static /* synthetic */ Diagram lambda$2(ICommand iCommand) {
        return (Diagram)iCommand.getCommandResult().getReturnValue();
    }
}

