/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import java.util.function.Supplier;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.command.CreateOrReuseViewCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.CreateNestedStateMachineDiagramCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.commands.RerouteTransitionsToConnectionPointsCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IRTPseudostateEditPart;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;

public class ReuseCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            ICommand setBoundsCommand;
            View view;
            if (!"InternalTransition_Label".equals(descriptor.getSemanticHint()) || !((view = (View)this.getHost().getModel()).getElement() instanceof State)) continue;
            State targetState = (State)view.getElement();
            if (!targetState.isComposite()) {
                ICommand composed = ReuseCreationEditPolicy.getStateAsCompositeCommand(editingDomain, targetState, (IGraphicalEditPart)this.getHost());
                composed = composed.compose((IUndoableOperation)new CreateOrReuseViewCommand(editingDomain, descriptor, (View)this.getHost().getModel()));
                setBoundsCommand = this.getSetBoundsCommand(request, descriptor);
                if (setBoundsCommand != null) {
                    composed = composed.compose((IUndoableOperation)setBoundsCommand);
                }
                cc.compose((IUndoableOperation)composed);
                continue;
            }
            CreateOrReuseViewCommand createCommand = new CreateOrReuseViewCommand(editingDomain, descriptor, (View)this.getHost().getModel());
            setBoundsCommand = this.getSetBoundsCommand(request, descriptor);
            if (setBoundsCommand != null) {
                createCommand = CompositeCommand.compose((ICommand)createCommand, (ICommand)setBoundsCommand);
            }
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    private static ICommand getStateAsCompositeCommand(TransactionalEditingDomain domain, State targetState, IGraphicalEditPart stateEditPart) {
        CreateNestedStateMachineDiagramCommand createDiagram = new CreateNestedStateMachineDiagramCommand(domain, targetState, stateEditPart, false);
        Supplier<Diagram> newDiagram = () -> ReuseCreationEditPolicy.lambda$0((ICommand)createDiagram);
        CreateNestedStateMachineDiagramCommand composed = createDiagram;
        ICommand rerouteTransitions = RerouteTransitionsToConnectionPointsCommand.createRerouteTransitionsCommand(domain, targetState, stateEditPart);
        if (rerouteTransitions != null) {
            composed = composed.compose((IUndoableOperation)rerouteTransitions);
        }
        composed = composed.compose((IUndoableOperation)ReuseCreationEditPolicy.getConnectionPointMatchingCommand(domain, targetState, stateEditPart, newDiagram));
        return composed;
    }

    private static ICommand getConnectionPointMatchingCommand(TransactionalEditingDomain domain, final State state, final IGraphicalEditPart stateEP, final Supplier<? extends Diagram> newDiagram) {
        return new AbstractTransactionalCommand(domain, "Arrange Connection Points", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View frame;
                Diagram smd = (Diagram)newDiagram.get();
                View view = frame = smd == null ? null : ViewUtil.getChildBySemanticHint((View)smd, (String)"State_Shape_TN");
                if (frame instanceof Node) {
                    Rectangle frameRect = this.getBounds((Node)frame);
                    Rectangle stateRect = this.getBounds(stateEP);
                    View stateView = stateEP.getNotationView();
                    for (Pseudostate connPt : state.getConnectionPoints()) {
                        Rectangle connPtRect = this.getBounds(this.findChildNode(stateView, (EObject)connPt));
                        RelativePortLocation loc = RelativePortLocation.of((Rectangle)connPtRect, (Rectangle)stateRect);
                        String semanticHint = connPt.getKind() == PseudostateKind.ENTRY_POINT_LITERAL ? "Pseudostate_EntryPointShape" : "Pseudostate_ExitPointShape";
                        Node onFrame = ViewService.getInstance().createNode((IAdaptable)new SemanticAdapter((EObject)connPt, null), frame, semanticHint, -1, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                        Point moveTo = loc.applyTo(frameRect, IRTPseudostateEditPart.getDefaultSize(connPt.getKind()));
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__X, (Object)moveTo.x());
                        ViewUtil.setStructuralFeatureValue((View)onFrame, (EStructuralFeature)NotationPackage.Literals.LOCATION__Y, (Object)moveTo.y());
                    }
                }
                return CommandResult.newOKCommandResult();
            }

            Rectangle getBounds(IGraphicalEditPart editPart) {
                return editPart.getFigure().getBounds().getCopy();
            }

            Node findChildNode(View parent, EObject element) {
                return parent.getChildren().stream().filter(Node.class::isInstance).map(Node.class::cast).filter(n -> n.getElement() == element).findFirst().get();
            }

            Rectangle getBounds(Node node) {
                Bounds result = (Bounds)node.getLayoutConstraint();
                return new Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
            }
        };
    }

    private static /* synthetic */ Diagram lambda$0(ICommand iCommand) {
        return (Diagram)iCommand.getCommandResult().getReturnValue();
    }
}

