/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.handlers;

import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.Either;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.handlers.Messages;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;

public class GoOutsideHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IGraphicalEditPart editPart = this.getSelectedEditPart(event);
        Optional<Diagram> diagram = this.getOutsideDiagram(editPart);
        diagram.ifPresent(this::openPage);
        return null;
    }

    protected Optional<Diagram> getOutsideDiagram(IGraphicalEditPart selection) {
        Optional<UMLRTState> compositeState = Optional.ofNullable(selection).filter(this::isDiagramOrFrameOrRegion).map(IGraphicalEditPart::resolveSemanticElement).map(this::getState).filter(UMLRTState::isComposite);
        Either parent = Either.or(compositeState.map(UMLRTVertex::getState), () -> compositeState.map(UMLRTVertex::getStateMachine)).map(UMLRTState::toUML, UMLRTStateMachine::toUML);
        return Optional.ofNullable((Diagram)parent.flatMap(state -> Optional.ofNullable(UMLRTStateMachineDiagramUtils.getStateMachineDiagram((State)state)), sm -> Optional.ofNullable(UMLRTStateMachineDiagramUtils.getStateMachineDiagram((StateMachine)sm))).orElse(Diagram.class, null));
    }

    protected IGraphicalEditPart getSelectedEditPart(ExecutionEvent event) {
        return this.getSelectedEditPart(event.getApplicationContext());
    }

    protected IGraphicalEditPart getSelectedEditPart(Object evaluationContext) {
        IStructuredSelection sel = (IStructuredSelection)TypeUtils.as((Object)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection"), (Object)StructuredSelection.EMPTY);
        return sel != null && !sel.isEmpty() ? (IGraphicalEditPart)PlatformHelper.getAdapter((Object)sel.getFirstElement(), IGraphicalEditPart.class) : null;
    }

    protected boolean isDiagramOrFrameOrRegion(IGraphicalEditPart editPart) {
        View view = editPart.getNotationView();
        return view != null && (view instanceof Diagram || "State_Shape_TN".equals(view.getType()) || "Region_Shape".equals(view.getType()));
    }

    protected UMLRTState getState(EObject semanticElement) {
        if (semanticElement instanceof Region) {
            return this.getState((EObject)((Region)semanticElement).getState());
        }
        Optional<State> result = Optional.ofNullable((State)TypeUtils.as((Object)semanticElement, State.class));
        return result.map(UMLRTState::getInstance).orElse(null);
    }

    protected void openPage(EObject pageIdentifier) {
        try {
            IPageManager pagemgr = ServiceUtilsForEObject.getInstance().getIPageManager((Object)pageIdentifier);
            if (pagemgr.isOpen((Object)pageIdentifier)) {
                pagemgr.selectPage((Object)pageIdentifier);
            } else {
                pagemgr.openPage((Object)pageIdentifier);
            }
        }
        catch (ServiceException e) {
            StatusAdapter status = new StatusAdapter((IStatus)new Status(4, "org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine", Messages.GoOutsideHandler_0, (Throwable)e));
            status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.GoOutsideHandler_1);
            status.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
            StatusManager.getManager().handle(status, 3);
        }
    }

    public void setEnabled(Object evaluationContext) {
        IGraphicalEditPart editPart = this.getSelectedEditPart(evaluationContext);
        Optional<Diagram> diagram = this.getOutsideDiagram(editPart);
        this.setBaseEnabled(diagram.isPresent());
    }
}

