/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.types.advice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils.UMLRTStateMachineDiagramUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTCapsule;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTStateMachine;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.StateMachine;

public class StateMachineInheritanceAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        ICommand result = super.getAfterConfigureCommand(request);
        EObject configuree = request.getElementToConfigure();
        Generalization generalization = (Generalization)TypeUtils.as((Object)configuree, Generalization.class);
        if (generalization != null && CapsuleUtils.isCapsule((Classifier)generalization.getSpecific())) {
            ICommand configure = this.getConfigureCapsuleGeneralizationCommand(generalization, request);
            if (configure != null) {
                result = result == null ? configure : result.compose((IUndoableOperation)configure);
            }
            return result;
        }
        StateMachine stateMachine = (StateMachine)TypeUtils.as((Object)configuree, StateMachine.class);
        if (stateMachine != null && CapsuleUtils.isCapsule((Classifier)stateMachine.getContext())) {
            ICommand configure = this.getConfigureInheritedStateMachinesCommand(stateMachine, request);
            if (configure != null) {
                result = result == null ? configure : result.compose((IUndoableOperation)configure);
            }
            return result;
        }
        return result;
    }

    protected ICommand getConfigureCapsuleGeneralizationCommand(Generalization generalization, ConfigureRequest request) {
        CreateStateMachineDiagramCommand result = null;
        UMLRTCapsule capsule = UMLRTCapsule.getInstance((Class)((Class)generalization.getSpecific()));
        if (capsule != null) {
            result = new CreateStateMachineDiagramCommand(request.getEditingDomain(), capsule.toUML());
        }
        return result;
    }

    protected ICommand getConfigureInheritedStateMachinesCommand(StateMachine stateMachine, ConfigureRequest request) {
        CreateStateMachineDiagramCommand result = null;
        Class class_ = (Class)TypeUtils.as((Object)stateMachine.getContext(), Class.class);
        UMLRTCapsule capsule = UMLRTCapsule.getInstance((Class)class_);
        if (capsule != null) {
            result = new CreateStateMachineDiagramCommand(request.getEditingDomain(), capsule.toUML());
        }
        return result;
    }

    protected static class CreateStateMachineDiagramCommand
    extends AbstractTransactionalCommand {
        private Class capsule;

        public CreateStateMachineDiagramCommand(TransactionalEditingDomain domain, Class capsule) {
            super(domain, "Create State Machine Diagram", CreateStateMachineDiagramCommand.withNotation((EditingDomain)domain, CreateStateMachineDiagramCommand.getWorkspaceFiles((EObject)capsule)));
            this.capsule = capsule;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            List result = Collections.emptyList();
            UMLRTCapsule capsule = UMLRTCapsule.getInstance((Class)this.capsule);
            if (capsule != null) {
                result = capsule.getHierarchy().map(UMLRTCapsule::getStateMachine).filter(Objects::nonNull).map(UMLRTStateMachine::toUML).filter(sm -> UMLRTStateMachineDiagramUtils.getStateMachineDiagram((StateMachine)sm) == null).map(sm -> UMLRTStateMachineDiagramUtils.createStateMachineDiagram((EObject)sm, null)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return CommandResult.newOKCommandResult(result);
        }

        static List<IFile> withNotation(EditingDomain domain, List<IFile> files) {
            List<IFile> result = Optional.ofNullable((ModelSet)TypeUtils.as((Object)domain.getResourceSet(), ModelSet.class)).map(NotationUtils::getNotationResource).map(WorkspaceSynchronizer::getFile).map(f -> {
                ArrayList<IFile> newFiles = new ArrayList<IFile>(files);
                newFiles.add((IFile)f);
                return newFiles;
            }).orElse(files);
            return result;
        }
    }
}

