/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.editors;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;
import org.eclipse.papyrusrt.umlrt.core.utils.EMFHacks;
import org.eclipse.papyrusrt.umlrt.tooling.tables.manager.axis.RTSynchronizedOnFeatureAxisManager;
import org.eclipse.papyrusrt.umlrt.tooling.ui.editors.AbstractInheritableMultipleReferenceEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultiReferenceControlEditor
extends AbstractInheritableMultipleReferenceEditor {
    private boolean adding;
    private Supplier<? extends INattableModelManager> tableManager;
    private RTSynchronizedOnFeatureAxisManager dataAxisManager;
    private ISelectionProvider selectionProvider;

    public MultiReferenceControlEditor(Composite parent, int style, EObject context, EStructuralFeature containment, Supplier<? extends INattableModelManager> nattableManager) {
        super(parent, true, true, null);
        this.tableManager = nattableManager;
    }

    public void createContents() {
        super.createContents();
    }

    protected Control createContents(Composite parent) {
        return this.getNatTable();
    }

    protected NatTable getNatTable() {
        INattableModelManager mgr = this.tableManager.get();
        return mgr == null ? null : (NatTable)mgr.getAdapter(NatTable.class);
    }

    protected RTSynchronizedOnFeatureAxisManager getDataAxisManager() {
        if (this.dataAxisManager == null) {
            INattableModelManager manager = this.tableManager.get();
            IAxisManager rowMgr = manager.getRowAxisManager();
            if (rowMgr instanceof ICompositeAxisManager) {
                ICompositeAxisManager composite = (ICompositeAxisManager)rowMgr;
                EStructuralFeatureAxis axis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
                axis.setManager((AxisManagerRepresentation)manager.getTable().getTableConfiguration().getRowHeaderAxisConfiguration().getAxisManagers().get(0));
                IAxisManager nested = composite.getSubAxisManagerFor((IAxis)axis);
                if (nested instanceof RTSynchronizedOnFeatureAxisManager) {
                    rowMgr = nested;
                }
            }
            this.dataAxisManager = (RTSynchronizedOnFeatureAxisManager)TypeUtils.as((Object)rowMgr, RTSynchronizedOnFeatureAxisManager.class);
        }
        return this.dataAxisManager;
    }

    protected void setInput(IObservableList modelProperty) {
    }

    public void refreshValue() {
        NatTable table = this.getNatTable();
        if (table != null) {
            table.refresh();
        }
    }

    protected ISelectionProvider getSelectionProvider(Control contentControl) {
        return this.getSelectionProvider();
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
    }

    public IBaseLabelProvider getLabelProvider() {
        return null;
    }

    protected void upAction() {
        IStructuredSelection selection = this.getSelection();
        super.upAction();
        this.adjustTableSelection(selection);
    }

    protected void downAction() {
        IStructuredSelection selection = this.getSelection();
        super.downAction();
        this.adjustTableSelection(selection);
    }

    protected void adjustTableSelection(IStructuredSelection selection) {
        this.getDisplay().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.getSelectionProvider().setSelection((ISelection)selection);
            }
        });
    }

    protected void updateShowExcluded() {
        super.updateShowExcluded();
        RTSynchronizedOnFeatureAxisManager axisMgr = this.getDataAxisManager();
        if (axisMgr != null) {
            axisMgr.setShowExclusions(this.toggleExcluded.getSelection());
        }
    }

    protected void removeAction() {
        List toRemove = this.getSelection().toList();
        super.removeAction();
        toRemove.forEach(this::handleExclusion);
    }

    protected void handleExclusion(Object removedElement) {
        RTSynchronizedOnFeatureAxisManager axisMgr = this.getDataAxisManager();
        if (axisMgr != null) {
            axisMgr.handleExclusion(removedElement);
        }
    }

    protected void addAction() {
        boolean wasAdding = this.adding;
        this.adding = true;
        try {
            super.addAction();
        }
        finally {
            this.adding = wasAdding;
        }
    }

    public IAtomicOperationExecutor getOperationExecutor(Object context) {
        EObject eObject;
        boolean nested;
        IAtomicOperationExecutor result = super.getOperationExecutor(context);
        if (this.adding && context instanceof EObject && (nested = EMFHacks.isReadWriteTransactionActive((EObject)(eObject = (EObject)context)))) {
            result = new QuietOperationExecutor(eObject, result).postProcess(o -> EMFHacks.notifyAdded((EObject)((EObject)o)));
        }
        return result;
    }

    private static class QuietOperationExecutor
    implements IAtomicOperationExecutor {
        private final EObject context;
        private final IAtomicOperationExecutor delegate;
        private Consumer<Object> postProcess;

        QuietOperationExecutor(EObject context, IAtomicOperationExecutor delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public void execute(Runnable operation, String label) {
            EMFHacks.silently((Notifier)this.context, __ -> this.delegate.execute(operation, label));
        }

        public <V> V execute(Callable<V> operation, String label) {
            class ResultCapture
            implements Callable<V> {
                V result;
                private final /* synthetic */ Callable val$operation;

                ResultCapture(Callable callable) {
                    this.val$operation = callable;
                }

                @Override
                public V call() throws Exception {
                    this.result = this.val$operation.call();
                    return this.result;
                }
            }
            ResultCapture result = new ResultCapture(operation);
            EMFHacks.silently((Notifier)this.context, __ -> {
                Object object = this.delegate.execute((Callable)result, label);
            });
            if (this.postProcess != null) {
                if (result.result instanceof Object[]) {
                    Stream.of((Object[])result.result).forEach(this.postProcess);
                } else if (result.result != null) {
                    this.postProcess.accept(result.result);
                }
            }
            return result.result;
        }

        QuietOperationExecutor postProcess(Consumer<Object> action) {
            this.postProcess = this.postProcess == null ? action : this.postProcess.andThen(action);
            return this;
        }
    }
}

