/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguage;
import org.eclipse.papyrusrt.umlrt.core.defaultlanguage.IDefaultLanguageService;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Type;

public class ParameterTypeContentProvider
extends EncapsulatedContentProvider {
    protected static final String UNDEFINED = "*";
    private EObject root;

    public ParameterTypeContentProvider(IStaticContentProvider provider) {
        super((IStructuredContentProvider)provider);
    }

    public boolean isValidValue(Object element) {
        boolean valid = super.isValidValue(element);
        if (!valid) {
            valid = UNDEFINED.equals(element) || element instanceof PrimitiveType;
        }
        return valid;
    }

    public Object[] getElements() {
        Object[] initialElements = super.getElements();
        ArrayList<Object> filteredElements = new ArrayList<Object>();
        filteredElements.add(UNDEFINED);
        filteredElements.addAll(this.getPrimitiveFromDefaultLanguage());
        int i = 0;
        while (i < initialElements.length) {
            EObject element = EMFHelper.getEObject((Object)initialElements[i]);
            if (element != null) {
                try {
                    ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)element);
                    Resource resource = ((UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).getResource();
                    if (resource.getContents().contains((Object)element)) {
                        this.root = element;
                        filteredElements.add(initialElements[i]);
                    }
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return filteredElements.toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        Object[] initialElements = super.getChildren(parentElement);
        ArrayList<Object> filteredElements = new ArrayList<Object>();
        int i = 0;
        while (i < initialElements.length) {
            EObject element = EMFHelper.getEObject((Object)initialElements[i]);
            if (element != null) {
                if (element instanceof Classifier && !CapsuleUtils.isCapsule((Classifier)((Classifier)element)) && !ProtocolUtils.isProtocol((EObject)element).booleanValue()) {
                    filteredElements.add(initialElements[i]);
                }
                if (element instanceof Package) {
                    filteredElements.add(initialElements[i]);
                }
            }
            ++i;
        }
        return filteredElements.toArray();
    }

    public Collection<Type> getPrimitiveFromDefaultLanguage() {
        Set<Object> specificPrimitiveTypes = new HashSet<Type>();
        try {
            IDefaultLanguageService service;
            if (this.root instanceof Element && this.root.eResource() != null && this.root.eResource().getResourceSet() != null && (service = (IDefaultLanguageService)ServiceUtilsForEObject.getInstance().getService(IDefaultLanguageService.class, (Object)this.root)) != null) {
                IDefaultLanguage language = service.getActiveDefaultLanguage((Element)this.root);
                specificPrimitiveTypes = language.getSpecificPrimitiveTypes(this.root.eResource().getResourceSet());
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return specificPrimitiveTypes;
    }
}

