/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.widget;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.properties.editors.MultiReferenceControlEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.providers.IRTTableSelectionProvider;
import org.eclipse.papyrusrt.umlrt.tooling.properties.providers.RTNattableSelectionService;
import org.eclipse.papyrusrt.umlrt.tooling.properties.providers.RTTableSelectionProvider;
import org.eclipse.papyrusrt.umlrt.tooling.properties.widget.RTNatTablePropertyEditor;
import org.eclipse.papyrusrt.umlrt.tooling.ui.util.InheritanceUIComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;

public class RTNatTableMultiReferencePropertyEditor
extends RTNatTablePropertyEditor {
    private static final int ROW_HEIGHT = 40;
    private IRTTableSelectionProvider selectionProvider;
    private RowSelectionProvider<?> rowSelectionProvider;
    private MultiReferenceControlEditor editor;
    protected int style;
    protected Class<? extends IControlManager> controlManagerClass;
    private IChangeListener modelChangeListener;

    public RTNatTableMultiReferencePropertyEditor(Composite parent, int style) {
        super(parent, style);
        this.style = style;
    }

    protected void dispose() {
        this.disposeControlEditor();
        RTNattableSelectionService.getInstance().removeSelectionProvider(this.selectionProvider);
        if (this.rowSelectionProvider != null) {
            if (this.nattableManager.getBodyLayerStack() != null) {
                SelectionLayer selectionLayer = this.nattableManager.getBodyLayerStack().getSelectionLayer();
                selectionLayer.removeLayerListener(this.rowSelectionProvider);
            }
            this.rowSelectionProvider = null;
        }
        if (this.modelChangeListener != null) {
            IObservableList list = this.getInputObservableList();
            if (list != null) {
                list.removeChangeListener(this.modelChangeListener);
            }
            this.modelChangeListener = null;
        }
    }

    protected void doBinding() {
        super.doBinding();
        IObservableList input = this.getInputObservableList();
        if (input != null) {
            input.addChangeListener(this.getModelChangeListener());
        }
    }

    protected void createPreviousWidgets(EObject sourceElement, EStructuralFeature feature) {
        super.createPreviousWidgets(sourceElement, feature);
        this.disposeControlEditor();
        this.editor = this.createControlEditor(sourceElement, feature);
        this.setEditor((AbstractListEditor)this.editor);
    }

    @Override
    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        IAxisManager rowMgr = manager.getRowAxisManager();
        if (rowMgr instanceof ICompositeAxisManager && manager.getTable().getContext() instanceof Element) {
            InheritanceUIComparator byInheritance = new InheritanceUIComparator();
            ((ICompositeAxisManager)rowMgr).setAxisComparator((Comparator)byInheritance);
        }
        NatTable result = super.createNatTableWidget(manager, parent, style, rows);
        this.setSelectionProvider();
        this.self.addDisposeListener(__ -> this.dispose());
        this.editor.createContents();
        return result;
    }

    protected MultiReferenceControlEditor createControlEditor(EObject sourceElement, EStructuralFeature feature) {
        MultiReferenceControlEditor editor = new MultiReferenceControlEditor((Composite)this.self, this.style, sourceElement, feature, () -> this.nattableManager);
        editor.setModelObservable(this.getInputObservableList());
        editor.setFactory(this.input.getValueFactory(this.propertyPath));
        editor.setDirectCreation(this.input.getDirectCreation(this.propertyPath));
        editor.setReadOnly(!this.input.isEditable(this.propertyPath));
        if (this.getControlManagerClass() != null) {
            this.hookControlManager(editor);
        }
        if (this.getProperty() != null) {
            editor.setDialogSettingsKey(this.getProperty());
        }
        return editor;
    }

    public void setProperty(String path) {
        super.setProperty(path);
        if (this.editor != null) {
            this.editor.setDialogSettingsKey(path);
        }
    }

    protected void configureLayout(EObject sourceElement) {
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        this.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.self.setLayout((Layout)layout);
        GridData editorData = new GridData(131072, 128, false, false);
        editorData.horizontalIndent = 0;
        this.editor.setLayoutData(editorData);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.minimumHeight = this.getInputObservableList().size() * 40;
        tableData.horizontalIndent = 0;
        this.natTableWidget.setLayoutData((Object)tableData);
        this.self.layout();
        this.editor.layout();
        super.configureLayout(sourceElement);
    }

    protected void setSelectionProvider() {
        SelectionLayer selectionLayer = this.nattableManager.getBodyLayerStack().getSelectionLayer();
        this.selectionProvider = new RTTableSelectionProvider(this.nattableManager, selectionLayer);
        RTNattableSelectionService.getInstance().addSelectionProvider(this.selectionProvider);
        this.rowSelectionProvider = new RowSelectionProvider(selectionLayer, this.rowDataProvider, false);
        this.editor.setSelectionProvider((ISelectionProvider)this.rowSelectionProvider);
    }

    protected void disposeControlEditor() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
    }

    public Class<? extends IControlManager> getControlManagerClass() {
        return this.controlManagerClass;
    }

    public void setControlManagerClass(Class<? extends IControlManager> controlManager) {
        this.controlManagerClass = controlManager;
        if (controlManager != null && this.editor != null) {
            this.hookControlManager(this.editor);
        }
    }

    protected void hookControlManager(MultiReferenceControlEditor editor) {
        if (this.getControlManagerClass() != null && editor != null) {
            IControlManager controlManager;
            try {
                controlManager = this.getControlManagerClass().newInstance();
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                return;
            }
            editor.enableAddElement(controlManager::canAddElement);
            editor.enableMoveElement(object -> controlManager.canMoveElement(this.nattableManager.getTable().getContext(), object));
            editor.enableRemoveElement(object -> controlManager.canRemoveElement(this.nattableManager.getTable().getContext(), object));
        }
    }

    private IChangeListener getModelChangeListener() {
        if (this.modelChangeListener == null) {
            this.modelChangeListener = event -> {
                IAxisManager rowMgr;
                if (this.editor != null && !this.editor.isDisposed() && (rowMgr = this.nattableManager.getRowAxisManager()) instanceof ICompositeAxisManager) {
                    ((ICompositeAxisManager)rowMgr).updateAxisContents();
                }
            };
        }
        return this.modelChangeListener;
    }

    public static interface IControlManager {
        default public boolean canAddElement(Object editedParent) {
            return true;
        }

        default public boolean canMoveElement(Object editedParent, Object object) {
            return true;
        }

        default public boolean canRemoveElement(Object editedParent, Object object) {
            return true;
        }
    }
}

