/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.widget;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractResourceUndoContextPolicy;
import org.eclipse.emf.workspace.IResourceUndoContextPolicy;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AggregateConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultRowSelectionLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusGridLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.AbstractNattableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.CellTextAlignment;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.CellTextStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.properties.widgets.NattablePropertyEditor;
import org.eclipse.papyrusrt.umlrt.tooling.properties.providers.RTNattableRowDataProvider;
import org.eclipse.papyrusrt.umlrt.tooling.tables.internal.handlers.RTTransactionalEditCellCommandHandler;
import org.eclipse.swt.widgets.Composite;

public class RTNatTablePropertyEditor
extends NattablePropertyEditor {
    private static final Map<CellTextAlignment, HorizontalAlignmentEnum> HALIGN = new EnumMap<CellTextAlignment, HorizontalAlignmentEnum>(CellTextAlignment.class);
    private static final Map<CellTextAlignment, VerticalAlignmentEnum> VALIGN;
    protected IRowDataProvider<Object> rowDataProvider;

    static {
        HALIGN.put(CellTextAlignment.TOP_LEFT, HorizontalAlignmentEnum.LEFT);
        HALIGN.put(CellTextAlignment.MIDDLE_LEFT, HorizontalAlignmentEnum.LEFT);
        HALIGN.put(CellTextAlignment.BOTTOM_LEFT, HorizontalAlignmentEnum.LEFT);
        HALIGN.put(CellTextAlignment.TOP_CENTER, HorizontalAlignmentEnum.CENTER);
        HALIGN.put(CellTextAlignment.MIDDLE_CENTER, HorizontalAlignmentEnum.CENTER);
        HALIGN.put(CellTextAlignment.BOTTOM_CENTER, HorizontalAlignmentEnum.CENTER);
        HALIGN.put(CellTextAlignment.TOP_RIGHT, HorizontalAlignmentEnum.RIGHT);
        HALIGN.put(CellTextAlignment.MIDDLE_RIGHT, HorizontalAlignmentEnum.RIGHT);
        HALIGN.put(CellTextAlignment.BOTTOM_RIGHT, HorizontalAlignmentEnum.RIGHT);
        VALIGN = new EnumMap<CellTextAlignment, VerticalAlignmentEnum>(CellTextAlignment.class);
        VALIGN.put(CellTextAlignment.TOP_LEFT, VerticalAlignmentEnum.TOP);
        VALIGN.put(CellTextAlignment.TOP_CENTER, VerticalAlignmentEnum.TOP);
        VALIGN.put(CellTextAlignment.TOP_RIGHT, VerticalAlignmentEnum.TOP);
        VALIGN.put(CellTextAlignment.MIDDLE_LEFT, VerticalAlignmentEnum.MIDDLE);
        VALIGN.put(CellTextAlignment.MIDDLE_CENTER, VerticalAlignmentEnum.MIDDLE);
        VALIGN.put(CellTextAlignment.MIDDLE_RIGHT, VerticalAlignmentEnum.MIDDLE);
        VALIGN.put(CellTextAlignment.BOTTOM_LEFT, VerticalAlignmentEnum.BOTTOM);
        VALIGN.put(CellTextAlignment.BOTTOM_CENTER, VerticalAlignmentEnum.BOTTOM);
        VALIGN.put(CellTextAlignment.BOTTOM_RIGHT, VerticalAlignmentEnum.BOTTOM);
    }

    public RTNatTablePropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected ServicesRegistry createServiceRegistry(EObject sourceElement) throws Exception {
        ServicesRegistry result = super.createServiceRegistry(sourceElement);
        TransactionalEditingDomain domain = (TransactionalEditingDomain)result.getService(TransactionalEditingDomain.class);
        CommandStack stack = domain.getCommandStack();
        if (stack instanceof IWorkspaceCommandStack) {
            MethodHandle policySetter = MethodHandles.publicLookup().findVirtual(stack.getClass(), "setResourceUndoContextPolicy", MethodType.methodType(Void.TYPE, IResourceUndoContextPolicy.class));
            AbstractResourceUndoContextPolicy policy = new AbstractResourceUndoContextPolicy(){

                protected boolean pessimisticCrossReferences() {
                    return false;
                }
            };
            try {
                policySetter.invoke(stack, (IResourceUndoContextPolicy)policy);
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return result;
    }

    protected NatTable createNatTableWidget(INattableModelManager manager, Composite parent, int style, Collection<?> rows) {
        NatTable result = super.createNatTableWidget(manager, parent, style, rows);
        GridLayer grid = (GridLayer)TypeUtils.as((Object)(result == null ? null : result.getLayer()), GridLayer.class);
        if (grid != null) {
            this.replaceEditCellCommandHandler(manager, grid);
        }
        if (manager instanceof NattableModelManager) {
            SelectionLayer selectionLayer = manager.getBodyLayerStack().getSelectionLayer();
            this.rowDataProvider = new RTNattableRowDataProvider((NattableModelManager)manager);
            IRowIdAccessor<Object> rowIdAccessor = new IRowIdAccessor<Object>(){

                public Serializable getRowId(Object rowObject) {
                    return Integer.valueOf(rowObject.hashCode());
                }
            };
            selectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(selectionLayer, this.rowDataProvider, (IRowIdAccessor)rowIdAccessor, false));
            selectionLayer.addConfiguration((IConfiguration)new DefaultRowSelectionLayerConfiguration());
        }
        this.configureCellStyle(result, manager);
        return result;
    }

    protected void configureCellStyle(NatTable table, INattableModelManager manager) {
        AbstractAxisProvider columnProvider = manager.getTable().getCurrentColumnAxisProvider();
        CellTextStyle textStyle = (CellTextStyle)columnProvider.getStyle(NattablestylePackage.Literals.CELL_TEXT_STYLE);
        this.configureCellStyle(table, manager, -1, textStyle, "BODY");
        DataLayer dataLayer = manager.getBodyLayerStack().getBodyDataLayer();
        ColumnOverrideLabelAccumulator acc = null;
        EList columns = columnProvider.getAxis();
        int i = 0;
        while (i < columns.size()) {
            textStyle = (CellTextStyle)((IAxis)columns.get(i)).getStyle(NattablestylePackage.Literals.CELL_TEXT_STYLE);
            if (textStyle != null) {
                if (acc == null) {
                    acc = new ColumnOverrideLabelAccumulator((ILayer)dataLayer);
                    this.ensureLabels((AbstractNattableWidgetManager)manager, (IConfigLabelAccumulator)acc);
                }
                String columnStyleLabel = "CELL_STYLE_" + i;
                acc.registerColumnOverrides(i, new String[]{columnStyleLabel});
                this.configureCellStyle(table, manager, i, textStyle, columnStyleLabel);
            }
            ++i;
        }
    }

    protected void configureCellStyle(NatTable table, INattableModelManager manager, int column, CellTextStyle textStyle, String configLabel) {
        int vpad;
        HorizontalAlignmentEnum halign = HorizontalAlignmentEnum.LEFT;
        VerticalAlignmentEnum valign = VerticalAlignmentEnum.TOP;
        Style cellStyle = new Style();
        if (textStyle != null) {
            CellTextAlignment align = textStyle.getAlignment();
            halign = HALIGN.get(align);
            valign = VALIGN.get(align);
        }
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)halign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)valign);
        table.getConfigRegistry().registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", configLabel);
        int hpad = halign != HorizontalAlignmentEnum.CENTER ? 3 : 0;
        int n = vpad = valign != VerticalAlignmentEnum.MIDDLE ? 3 : 0;
        if (hpad != 0 || vpad != 0) {
            ICellPainter painter;
            if (column < 0) {
                painter = (ICellPainter)table.getConfigRegistry().getConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", new String[]{"BODY"});
            } else {
                LabelStack labels = manager.getBodyLayerStack().getBodyDataLayer().getConfigLabelsByPosition(column, 0);
                painter = (ICellPainter)table.getConfigRegistry().getConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", labels.getLabels());
            }
            PaddingDecorator padding = new PaddingDecorator(painter, vpad, hpad, vpad, hpad);
            table.getConfigRegistry().registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)padding, "NORMAL", configLabel);
        }
    }

    private void ensureLabels(AbstractNattableWidgetManager manager, final IConfigLabelAccumulator accumulator) {
        final DataLayer dataLayer = manager.getBodyLayerStack().getBodyDataLayer();
        IConfigLabelAccumulator existing = dataLayer.getConfigLabelAccumulator();
        Runnable injectLabels = new Runnable(existing){
            private IConfigLabelAccumulator lastKnown;
            {
                this.lastKnown = iConfigLabelAccumulator;
            }

            @Override
            public void run() {
                IConfigLabelAccumulator current = dataLayer.getConfigLabelAccumulator();
                if (current != this.lastKnown) {
                    if (current == null) {
                        dataLayer.setConfigLabelAccumulator(accumulator);
                    } else {
                        AggregateConfigLabelAccumulator aggLabels = new AggregateConfigLabelAccumulator();
                        aggLabels.add(accumulator);
                        aggLabels.add(current);
                        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)aggLabels);
                    }
                    this.lastKnown = dataLayer.getConfigLabelAccumulator();
                }
            }
        };
        injectLabels.run();
        manager.getColumnHeaderLayerStack().addLayerListener(event -> injectLabels.run());
    }

    private void replaceEditCellCommandHandler(INattableModelManager manager, GridLayer grid) {
        Map commandHandlers;
        if (grid instanceof PapyrusGridLayer && (commandHandlers = (Map)RTNatTablePropertyEditor.getField(grid, "commandHandlers")) != null) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)manager.getTable().getContext());
            RTTransactionalEditCellCommandHandler handler = new RTTransactionalEditCellCommandHandler(domain);
            commandHandlers.put(handler.getCommandClass(), handler);
        }
    }

    static <T> T getField(Object object, String fieldName) {
        Object result = null;
        Class<?> search = object.getClass();
        while (search != null) {
            try {
                Field field = search.getDeclaredField(fieldName);
                field.setAccessible(true);
                result = field.get(object);
                break;
            }
            catch (Exception exception) {
                search = search.getSuperclass();
            }
        }
        return (T)result;
    }
}

