/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.tables.configurations;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CrossAxisWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

public abstract class AbstractTriggerTableCellEditorConfiguration
implements ICellAxisConfiguration {
    static final String TABLE_CONFIGURATION_TYPE = "TriggerTable";
    private final String id;
    private final String description;
    private final EStructuralFeature feature;

    protected AbstractTriggerTableCellEditorConfiguration(String id, String description, EStructuralFeature feature) {
        this.id = id;
        this.description = description;
        this.feature = feature;
    }

    public String getConfigurationId() {
        return this.id;
    }

    public String getConfigurationDescription() {
        return this.description;
    }

    protected EStructuralFeature getFeature() {
        return this.feature;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        INattableModelManager nattableManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        this.configureCellEditor(nattableManager, configRegistry, axis, configLabel);
    }

    protected void configureCellEditor(INattableModelManager manager, IConfigRegistry configRegistry, Object axis, String configLabel) {
        Table table = manager.getTable();
        ICellPainter cellPainter = this.getCellPainter(table, manager, axis);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cellPainter, "NORMAL", configLabel);
    }

    protected Image getImage(INattableModelManager manager, ILayerCell cell, IConfigRegistry configRegistry) {
        Trigger trigger;
        UMLRTTrigger facade;
        Image result = null;
        CrossAxisWrapper wrapper = UMLTableUtils.getRealEditedObject((ILayerCell)cell, (ITableAxisElementProvider)manager.getTableAxisElementProvider());
        if (wrapper.getFirstAxis() instanceof Trigger && (facade = UMLRTTrigger.getInstance((Trigger)(trigger = (Trigger)wrapper.getFirstAxis()))) != null) {
            try {
                result = this.getImage(facade);
            }
            catch (ServiceException serviceException) {}
        }
        return result;
    }

    protected abstract Image getImage(UMLRTTrigger var1) throws ServiceException;

    protected ICellPainter getCellPainter(Table table, INattableModelManager manager, Object axis) {
        ICellPainter image = this.getImageCellPainter(table, manager, axis);
        return new CellPainterDecorator((ICellPainter)new TextPainter(), CellEdgeEnum.LEFT, 5, image);
    }

    protected ICellPainter getImageCellPainter(Table table, final INattableModelManager manager, Object axis) {
        ImagePainter result = new ImagePainter(){

            protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
                Image result = AbstractTriggerTableCellEditorConfiguration.this.getImage(manager, cell, configRegistry);
                if (result == null) {
                    result = super.getImage(cell, configRegistry);
                }
                return result;
            }
        };
        result.setCalculateByWidth(true);
        return result;
    }

    public boolean handles(Table table, Object axisElement) {
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        return table.getContext() instanceof Transition && TABLE_CONFIGURATION_TYPE.equals(table.getTableConfiguration().getType()) && object == this.feature;
    }
}

