/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.facade.IFacadeProperty;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.properties.IFilteredListProperty;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.properties.PapyrusRTListProperty;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.provider.UMLRTEditPlugin;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

class FacadeListProperty<S extends UMLRTNamedElement, T extends UMLRTNamedElement>
extends PapyrusRTListProperty<S, T>
implements IFilteredListProperty<S, T>,
IFacadeProperty {
    FacadeListProperty(Class<T> elementType, EStructuralFeature facadeFeature, EStructuralFeature umlFeature) {
        super(elementType, facadeFeature, umlFeature);
    }

    @Override
    public String getPropertyName() {
        return UMLRTEditPlugin.INSTANCE.getString(String.format("_UI_%s_%s_feature", this.sourceFeature.getEContainingClass().getName(), this.sourceFeature.getName()));
    }

    @Override
    protected Stream<T> stream(S source) {
        Stream result = this.eList(source).stream();
        Stream<UMLRTNamedElement> excluded = source.getExcludedElements().stream().filter(this.elementType::isInstance).map(this.elementType::cast);
        return Stream.concat(result, excluded);
    }

    @Override
    protected Element unwrapSource(S source) {
        return source.toUML();
    }

    @Override
    protected Element unwrap(T element) {
        return element.toUML();
    }

    @Override
    protected Object wrap(Element element) {
        return UMLRTFactory.create((NamedElement)((NamedElement)element));
    }
}

