/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.editors;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractMultipleReferenceEditor;
import org.eclipse.papyrusrt.umlrt.core.commands.ExclusionCommand;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.IFilteredObservableList;
import org.eclipse.papyrusrt.umlrt.uml.FacadeObject;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTExtensionUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractInheritableMultipleReferenceEditor
extends AbstractMultipleReferenceEditor {
    private static final String SHOW_EXCLUDED_SETTING = "showExcluded";
    private String dialogSettingsKey;
    protected Button toggleExcluded;
    protected Button reinherit;
    protected Predicate<Object> canAddElement = Objects::nonNull;
    protected Predicate<Object> canMoveElement = Objects::nonNull;
    protected Predicate<Object> canRemoveElement = Objects::nonNull;
    private Predicate<Object> inheritanceFilter;
    private ISelectionChangedListener upDownEnablementListener;
    private ISelectionChangedListener editEnablementListener;

    public AbstractInheritableMultipleReferenceEditor(Composite parent) {
        this(parent, false, false, null);
    }

    public AbstractInheritableMultipleReferenceEditor(Composite parent, String label) {
        this(parent, false, false, label);
    }

    public AbstractInheritableMultipleReferenceEditor(Composite parent, boolean ordered, boolean unique, String label) {
        super(parent, ordered, unique, label);
    }

    protected void createContents() {
        super.createContents();
        GridLayout layout = new GridLayout(7, false);
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.controlsSection.setLayout((Layout)layout);
        this.updateControls();
    }

    public final void setDialogSettingsKey(String key) {
        this.dialogSettingsKey = key;
        this.loadDialogSettings();
    }

    public final String getDialogSettingsKey() {
        return this.dialogSettingsKey;
    }

    protected final String getDialogSettingsKey(String subkey) {
        String result = this.getDialogSettingsKey();
        return result == null ? null : String.format("%s.%s", result, subkey);
    }

    protected Object getContextElement() {
        Object result = super.getContextElement();
        if (result instanceof FacadeObject) {
            result = ((FacadeObject)result).toUML();
        }
        return result;
    }

    protected void createListControls() {
        ImageDescriptor toggleInheritedImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/etool16/show_excluded.png");
        this.toggleExcluded = this.createToggleButton(ExtendedImageRegistry.INSTANCE.getImage((Object)toggleInheritedImage), false, "Show excluded elements");
        super.createListControls();
        this.remove.setToolTipText("Remove or exclude selected element");
        ImageDescriptor reinheritImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)"$nl$/icons/full/etool16/reinherit.png");
        this.reinherit = this.createButton(ExtendedImageRegistry.INSTANCE.getImage((Object)reinheritImage), "Re-inherit selected element");
        this.loadDialogSettings();
    }

    protected Button createToggleButton(Image image, boolean selected, String tooltip) {
        Button result = new Button(this.controlsSection, 2);
        result.setImage(image);
        result.setSelection(selected);
        result.setToolTipText(tooltip);
        result.addSelectionListener((SelectionListener)this);
        return result;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.toggleExcluded) {
            this.toggleExcludedAction();
        } else if (e.widget == this.reinherit) {
            this.reinheritAction();
        } else {
            super.widgetSelected(e);
        }
    }

    protected void updateControls() {
        super.updateControls();
        if (this.controlsSection.getLayout() instanceof GridLayout) {
            this.setExclusion((Control)this.up, !this.ordered);
            this.setExclusion((Control)this.down, !this.ordered);
        }
        this.add.setEnabled(this.canAdd());
        if (!this.canRemove()) {
            this.remove.setEnabled(false);
        }
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        if (this.ordered) {
            if (this.upDownEnablementListener == null) {
                this.addSelectionChangedListener(this.getUpDownEnablementListener());
            }
            this.updateUpDownEnablement(this.getSelection());
        }
        this.toggleExcluded.setEnabled(!this.readOnly && this.modelProperty instanceof IFilteredObservableList);
        this.reinherit.setEnabled(!this.readOnly && this.canReinherit());
        if (this.editEnablementListener == null) {
            this.addSelectionChangedListener(this.getEditEnablementListener());
        }
        this.edit.setEnabled(this.canEdit(this.getSelection().getFirstElement()));
    }

    private ISelectionChangedListener getUpDownEnablementListener() {
        if (this.upDownEnablementListener == null) {
            this.upDownEnablementListener = event -> this.updateUpDownEnablement(event.getStructuredSelection());
        }
        return this.upDownEnablementListener;
    }

    void updateUpDownEnablement(IStructuredSelection selection) {
        if (this.up != null && this.down != null) {
            List elements = selection.toList();
            boolean makesSense = this.ordered && !elements.isEmpty() && this.isHomogeneous(elements, this::getInheritanceKindOf);
            this.up.setEnabled(makesSense && this.canMoveUp(elements));
            this.down.setEnabled(makesSense && this.canMoveDown(elements));
        }
    }

    private ISelectionChangedListener getEditEnablementListener() {
        if (this.editEnablementListener == null) {
            this.editEnablementListener = event -> this.updateEditEnablement(event.getStructuredSelection());
        }
        return this.editEnablementListener;
    }

    void updateEditEnablement(IStructuredSelection selection) {
        if (this.edit != null) {
            Object element = selection.getFirstElement();
            this.edit.setEnabled(element != null && this.canEdit(element));
        }
    }

    protected final <E> boolean isHomogeneous(Collection<? extends E> elements, Function<? super E, ?> mapping) {
        return elements.stream().map(mapping).distinct().count() < 2L;
    }

    protected Predicate<Object> getInheritanceFilter(boolean demandCreate) {
        if (this.inheritanceFilter == null && demandCreate) {
            Predicate<Object> isExcluded = o -> {
                EObject eObject = EMFHelper.getEObject((Object)o);
                return eObject instanceof FacadeObject ? ((FacadeObject)eObject).isExcluded() : eObject instanceof Element && UMLRTExtensionUtil.isExcluded((Element)((Element)eObject));
            };
            this.inheritanceFilter = isExcluded.negate();
        }
        return this.inheritanceFilter;
    }

    protected void toggleExcludedAction() {
        this.updateShowExcluded();
        this.commit();
        this.storeDialogSettings();
    }

    protected void updateShowExcluded() {
        if (this.toggleExcluded == null) {
            return;
        }
        boolean showExcluded = this.toggleExcluded.getSelection();
        if (this.modelProperty instanceof IFilteredObservableList) {
            IFilteredObservableList list = (IFilteredObservableList)this.modelProperty;
            Predicate<Object> filter = this.getInheritanceFilter(!showExcluded);
            boolean filterChanged = false;
            if (showExcluded) {
                if (filter != null) {
                    filterChanged = list.removeFilter(filter);
                }
            } else {
                filterChanged = list.addFilter(filter);
            }
            if (filterChanged && !this.isDisposed()) {
                this.refreshValue();
            }
        }
    }

    protected void reinheritAction() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelectionProvider((Control)this.reinherit).getSelection();
        List toReinherit = selection.toList().stream().filter(this::isInherited).map(this::toUML).filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
        if (!toReinherit.isEmpty()) {
            Element any = (Element)toReinherit.get(0);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)any);
            ICommand command = ExclusionCommand.getExclusionCommand((TransactionalEditingDomain)domain, toReinherit, (boolean)false);
            domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)command));
        }
        this.commit();
    }

    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        this.loadDialogSettings();
    }

    public void handleChange(ChangeEvent event) {
        if (!this.isDisposed() && event.getObservable() == this.modelProperty) {
            this.updateShowExcluded();
        }
        super.handleChange(event);
    }

    protected void loadDialogSettings() {
        if (this.modelProperty == null) {
            return;
        }
        if (this.toggleExcluded != null) {
            boolean showExcluded = false;
            String setting = this.getDialogSettingsKey(SHOW_EXCLUDED_SETTING);
            if (setting != null) {
                showExcluded = this.getBoolean(setting, false);
                this.toggleExcluded.setSelection(showExcluded);
                this.updateShowExcluded();
            }
        }
    }

    protected void storeDialogSettings() {
        String setting;
        if (this.toggleExcluded != null && (setting = this.getDialogSettingsKey(SHOW_EXCLUDED_SETTING)) != null) {
            this.setBoolean(setting, this.toggleExcluded.getSelection());
        }
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"InheritableMultipleReferenceEditor");
        return section.get(key) == null ? defaultValue : section.getBoolean(key);
    }

    protected void setBoolean(String key, boolean value) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"InheritableMultipleReferenceEditor");
        section.put(key, value);
    }

    protected boolean canMoveUp(Collection<?> selection) {
        boolean result = true;
        for (Object next : selection) {
            UMLRTInheritanceKind before;
            if (!this.canMoveElement.test(next)) {
                result = false;
                break;
            }
            int index = this.modelProperty.indexOf(next);
            UMLRTInheritanceKind kind = this.getInheritanceKindOf(next);
            if (kind == UMLRTInheritanceKind.INHERITED) {
                result = false;
                break;
            }
            UMLRTInheritanceKind uMLRTInheritanceKind = before = index > 0 ? this.getInheritanceKindOf(this.modelProperty.get(index - 1)) : null;
            if (before == kind) continue;
            result = false;
            break;
        }
        return result;
    }

    protected UMLRTInheritanceKind getInheritanceKindOf(Object object) {
        return object instanceof UMLRTNamedElement ? ((UMLRTNamedElement)object).getInheritanceKind() : (object instanceof Element ? UMLRTInheritanceKind.of((Element)((Element)object)) : UMLRTInheritanceKind.NONE);
    }

    protected EObject toUML(Object source) {
        return source instanceof FacadeObject ? ((FacadeObject)source).toUML() : EMFHelper.getEObject((Object)source);
    }

    protected boolean isInherited(Object source) {
        return this.getInheritanceKindOf(source) != UMLRTInheritanceKind.NONE;
    }

    protected boolean canMoveDown(Collection<?> selection) {
        boolean result = true;
        int last = this.modelProperty.size() - 1;
        for (Object next : selection) {
            UMLRTInheritanceKind after;
            int index = this.modelProperty.indexOf(next);
            UMLRTInheritanceKind kind = this.getInheritanceKindOf(next);
            if (kind == UMLRTInheritanceKind.INHERITED) {
                result = false;
                break;
            }
            UMLRTInheritanceKind uMLRTInheritanceKind = after = index < last ? this.getInheritanceKindOf(this.modelProperty.get(index + 1)) : null;
            if (after == kind) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean canEdit(Object element) {
        boolean result = false;
        EObject eObject = this.toUML(element);
        if (eObject != null && !EMFHelper.isReadOnly((EObject)eObject)) {
            result = Optional.of(eObject).filter(Element.class::isInstance).map(Element.class::cast).map(e -> !this.isInherited(e) || UMLRTProfileUtils.canRedefine((Element)e)).orElse(result);
        }
        return result;
    }

    public void enableAddElement(Predicate<Object> canAddElement) {
        this.canAddElement = this.canAddElement.and(canAddElement);
        if (this.modelProperty != null && this.add != null) {
            this.updateControls();
        }
    }

    protected boolean canAdd() {
        return this.canAddElement.test(this.getContextElement());
    }

    public void enableMoveElement(Predicate<Object> canMoveElement) {
        this.canMoveElement = this.canMoveElement.and(canMoveElement);
    }

    public void enableRemoveElement(Predicate<Object> canRemoveElement) {
        this.canRemoveElement = this.canRemoveElement.and(canRemoveElement);
    }

    protected boolean canRemove() {
        return this.getSelection().toList().stream().allMatch(this.canRemoveElement);
    }

    protected boolean canReinherit() {
        List selection = this.getSelection().toList();
        return !selection.isEmpty() && selection.stream().allMatch(e -> {
            EObject eObject = this.toUML(e);
            return eObject instanceof Element && UMLRTProfileUtils.canReinherit((Element)((Element)eObject));
        });
    }
}

