/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.advice;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPortKind;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

public class ConnectorEndPortsCompatibilityAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        if (request.getContainmentFeature() != UMLPackage.Literals.STRUCTURED_CLASSIFIER__OWNED_CONNECTOR) {
            return null;
        }
        if (!(request.getSource() instanceof Port) || !(request.getTarget() instanceof Port)) {
            return null;
        }
        return this.getConfirmCompatibilityCommand((IEditCommandRequest)request, (Port)request.getSource(), (Port)request.getTarget());
    }

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        if (!(request.getRelationship() instanceof Connector)) {
            return null;
        }
        Connector connector = (Connector)request.getRelationship();
        if (connector.getEnds().size() != 2) {
            return null;
        }
        ConnectableElement otherEnd = ((ConnectorEnd)connector.getEnds().get(request.getDirection() == 2 ? 0 : 1)).getRole();
        if (!(otherEnd instanceof Port) || !(request.getNewRelationshipEnd() instanceof Port)) {
            return null;
        }
        return this.getConfirmCompatibilityCommand((IEditCommandRequest)request, (Port)otherEnd, (Port)request.getNewRelationshipEnd());
    }

    protected ICommand getConfirmCompatibilityCommand(final IEditCommandRequest request, final Port port1, final Port port2) {
        return new AbstractTransactionalCommand(request.getEditingDomain(), "Check Connection", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Shell shell;
                boolean canConnect = true;
                if (port1.getType() == null || !port1.getType().equals(port2.getType())) {
                    canConnect = false;
                }
                if (canConnect) {
                    canConnect = ConnectorEndPortsCompatibilityAdvice.this.checkConjugationCompatibility(request, port1, port2);
                }
                if (!canConnect && ((Boolean)TypeUtils.as((Object)request.getParameter("USE_GUI"), (Object)true)).booleanValue() && (shell = Display.getCurrent().getActiveShell()) != null) {
                    canConnect = MessageDialog.openConfirm((Shell)shell, (String)"Incompatible Ports", (String)"The two ports are not compatible. Do you still want to create a connector?");
                }
                return canConnect ? CommandResult.newOKCommandResult() : CommandResult.newCancelledCommandResult();
            }
        };
    }

    private boolean checkConjugationCompatibility(IEditCommandRequest request, Port port1, Port port2) {
        boolean result = true;
        View port1View = null;
        View port2View = null;
        if (request instanceof CreateRelationshipRequest) {
            port1View = (View)request.getParameter("TARGET_GRAPHICAL_VIEW");
            port2View = (View)request.getParameter("SOURCE_GRAPHICAL_VIEW");
        } else {
            Edge reorientedEdge = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
            if (reorientedEdge != null) {
                View newEndView = RequestParameterUtils.getReconnectedEndView((IEditCommandRequest)request);
                if (((ReorientRelationshipRequest)request).getDirection() == 1) {
                    port1View = reorientedEdge.getTarget();
                    port2View = newEndView;
                } else {
                    port1View = reorientedEdge.getSource();
                    port2View = newEndView;
                }
            }
        }
        if (port2View != null && port2View.eContainer() != null && port1View != null && port1View.eContainer() != null) {
            boolean isDelegation;
            EObject port1Container = ((View)port2View.eContainer()).getElement();
            EObject port2Container = ((View)port1View.eContainer()).getElement();
            UMLRTPortKind port1Kind = RTPortUtils.getPortKind((Port)port1);
            UMLRTPortKind port2Kind = RTPortUtils.getPortKind((Port)port2);
            boolean bl = isDelegation = ElementTypeUtils.matches((EObject)port1Container, (String)"org.eclipse.papyrusrt.umlrt.core.Capsule") != false && port1.isService() || ElementTypeUtils.matches((EObject)port2Container, (String)"org.eclipse.papyrusrt.umlrt.core.Capsule") != false && port2.isService();
            if (!isDelegation) {
                if (port1.isConjugated() == port2.isConjugated()) {
                    result = false;
                }
            } else if (port1Container == port2Container && port1Kind == UMLRTPortKind.RELAY && port2Kind == UMLRTPortKind.RELAY) {
                if (port1.isConjugated() == port2.isConjugated()) {
                    result = false;
                }
            } else if (port1.isConjugated() != port2.isConjugated()) {
                result = false;
            }
        }
        return result;
    }
}

