/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.handlers;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.AbstractSourceProvider;

public class OverrideDeleteSourceProvider
extends AbstractSourceProvider {
    private static final String OVERRIDE_DELETE = "papyrusrt.override.delete";
    private static final String[] SOURCES = new String[]{"papyrusrt.override.delete"};
    private static final int PRIORITY = 0x8000000;
    private static AtomicBoolean overrideEnabled = new AtomicBoolean();
    private static List<OverrideDeleteSourceProvider> instances = new ArrayList<OverrideDeleteSourceProvider>(1);
    private ISelection selection = StructuredSelection.EMPTY;

    public OverrideDeleteSourceProvider() {
        instances.add(this);
    }

    public String[] getProvidedSourceNames() {
        return SOURCES;
    }

    public Map getCurrentState() {
        return overrideEnabled.get() ? ImmutableMap.of((Object)OVERRIDE_DELETE, (Object)true, (Object)"activeMenuSelection", (Object)this.selection) : ImmutableMap.of((Object)OVERRIDE_DELETE, (Object)false);
    }

    public void dispose() {
        instances.remove((Object)this);
    }

    void setSelection(ISelection selection) {
        this.selection = selection == null ? StructuredSelection.EMPTY : selection;
    }

    static boolean setEnabled(boolean enableOverride, ISelection selection) {
        boolean result = overrideEnabled.compareAndSet(!enableOverride, enableOverride);
        if (result) {
            if (enableOverride) {
                instances.forEach(p -> {
                    try {
                        p.setSelection(selection);
                        p.fireSourceChanged(Integer.MIN_VALUE, "activeMenuSelection", selection);
                    }
                    finally {
                        p.setSelection(null);
                    }
                });
            }
            instances.forEach(p -> p.fireSourceChanged(0x8000000, OVERRIDE_DELETE, enableOverride));
        }
        return result;
    }
}

