/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.NewElementUtil;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.providers.PortContentProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.providers.ProtocolMsgContentProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.providers.ProtocolMsgLabelProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.DialogUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

public class PortAndMsgReference
extends AbstractPropertyEditor {
    public static final String UML_TRIGGER_EVENT = "UML:Trigger:event";
    public static final String PROTOCOL_MESSAGES = " Protocol messages ";
    public static final String PORTS = " Ports ";
    protected CheckboxTableViewer fPorts;
    protected CheckboxTreeViewer fMessages;
    protected Package m_model;
    protected Class capsule;
    protected Button createProtocolMsgButton;
    protected IDataSourceListener dsListener;
    protected boolean addMode;
    protected boolean inSave;
    protected IChangeListener portChangeListener;
    protected IChangeListener msgChangeListener;
    protected Button okButton;
    protected Transition transition;
    IStaticContentProvider portContentProvider;
    ILabelProvider portLabelProvider;
    IStaticContentProvider messageContentProvider;
    ILabelProvider messageLabelProvider;
    TransactionalEditingDomain domain;
    protected Trigger trigger;

    public PortAndMsgReference(Composite parent, int style) {
        GridLayout grid = new GridLayout(2, true);
        Composite selections = new Composite(parent, 0);
        selections.setLayout((Layout)grid);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        selections.setLayoutData((Object)gridData);
        this.createPortSelectionGroup(selections);
        this.createMessageSelectionGroup(selections);
        this.okButton = DialogUtils.findOkButton((Control)DialogUtils.getDialogShell((Control)parent));
        this.addMode = false;
        this.inSave = false;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent dp) {
                PortAndMsgReference.this.save(SaveMode.ADDITIONAL_TRIGGER);
                PortAndMsgReference.this.removeChangeListeners();
            }
        });
        this.dsListener = new IDataSourceListener(){

            public void dataSourceChanged(DataSourceChangedEvent event) {
                PortAndMsgReference.this.setInput(event.getDataSource());
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PortAndMsgReference.this.removeChangeListeners();
                        PortAndMsgReference.this.doBinding();
                    }
                });
            }
        };
        this.portChangeListener = new IChangeListener(){

            public void handleChange(ChangeEvent ce) {
                if (!PortAndMsgReference.this.inSave) {
                    PortAndMsgReference.this.setPortChecks();
                    PortAndMsgReference.this.fMessages.setInput((Object)this);
                    PortAndMsgReference.this.setMessageChecks();
                }
            }
        };
        this.msgChangeListener = new IChangeListener(){

            public void handleChange(ChangeEvent ce) {
                if (!PortAndMsgReference.this.inSave) {
                    PortAndMsgReference.this.setMessageChecks();
                }
            }
        };
    }

    protected void installChangeListeners() {
        if (this.input != null) {
            IObservable observablePort = this.input.getObservable(this.propertyPath);
            IObservable observableEvent = this.input.getObservable(UML_TRIGGER_EVENT);
            observablePort.addChangeListener(this.portChangeListener);
            observableEvent.addChangeListener(this.msgChangeListener);
        }
    }

    protected void removeChangeListeners() {
        if (this.input != null) {
            IObservable observablePort = this.input.getObservable(this.propertyPath);
            IObservable observableEvent = this.input.getObservable(UML_TRIGGER_EVENT);
            observablePort.removeChangeListener(this.portChangeListener);
            observableEvent.removeChangeListener(this.msgChangeListener);
        }
    }

    protected void save(final SaveMode saveMode) {
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        try {
            history.execute((IUndoableOperation)new AbstractTransactionalCommand(this.domain, "trigger changes", Collections.EMPTY_LIST){

                public CommandResult doExecuteWithResult(IProgressMonitor dummy, IAdaptable info) {
                    PortAndMsgReference.this.doSave(saveMode);
                    return CommandResult.newOKCommandResult();
                }
            }, null, null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void doSave(SaveMode saveMode) {
        this.inSave = true;
        Object[] checkedElements = this.fMessages.getCheckedElements();
        if (saveMode == SaveMode.PORTS) {
            this.trigger.getPorts().clear();
            Object[] objectArray = this.fPorts.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object port = objectArray[n2];
                this.trigger.getPorts().add((Object)((Port)port));
                ++n2;
            }
        } else if (saveMode == SaveMode.MESSAGES) {
            this.trigger.setEvent(checkedElements.length > 0 ? (Event)checkedElements[0] : null);
        } else if (saveMode == SaveMode.ADDITIONAL_TRIGGER && checkedElements.length > 1 && this.addMode && !(this.fMessages.getCheckedElements()[0] instanceof AnyReceiveEvent) && this.transition != null) {
            int i = 1;
            while (i < checkedElements.length) {
                Trigger additionalTrigger = this.transition.createTrigger(null);
                additionalTrigger.getPorts().addAll((Collection)this.trigger.getPorts());
                additionalTrigger.setEvent((Event)checkedElements[i]);
                ++i;
            }
        }
        this.inSave = false;
    }

    protected void createPortSelectionGroup(Composite parent) {
        Composite gPortSelGroup = new Composite(parent, 0);
        Label label = new Label(gPortSelGroup, 0);
        label.setText(PORTS);
        gPortSelGroup.setLayout((Layout)new GridLayout(1, false));
        gPortSelGroup.setLayoutData((Object)new GridData(1808));
        this.fPorts = CheckboxTableViewer.newCheckList((Composite)gPortSelGroup, (int)0);
        GridData portSelGridData = new GridData(1808);
        portSelGridData.heightHint = 150;
        portSelGridData.widthHint = 250;
        this.fPorts.getTable().setLayoutData((Object)portSelGridData);
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                if (obj instanceof Port) {
                    PortAndMsgReference.this.save(SaveMode.PORTS);
                    PortAndMsgReference.this.fMessages.setInput((Object)this);
                    PortAndMsgReference.this.updateCreateProtocolMsgState();
                    ArrayList<Object> availableEvents = new ArrayList<Object>();
                    availableEvents.addAll(Arrays.asList(PortAndMsgReference.this.messageContentProvider.getElements()));
                    availableEvents.addAll(Arrays.asList(((ITreeContentProvider)PortAndMsgReference.this.messageContentProvider).getChildren(null)));
                    Event umlEvent = PortAndMsgReference.this.trigger.getEvent();
                    if (umlEvent != null && !availableEvents.contains(umlEvent)) {
                        PortAndMsgReference.this.save(SaveMode.MESSAGES);
                    } else {
                        PortAndMsgReference.this.setMessageChecks();
                    }
                    PortAndMsgReference.this.updateOkButtonState();
                }
            }
        };
        this.fPorts.addCheckStateListener(checkListener);
    }

    protected void updateCreateProtocolMsgState() {
        Port port;
        Object[] portObjs = this.fPorts.getCheckedElements();
        if (portObjs.length != 1 || !(portObjs[0] instanceof Port) || (port = (Port)portObjs[0]).getType() == null || port.getType().eResource() == this.trigger.eResource()) {
            // empty if block
        }
    }

    protected void updateOkButtonState() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.trigger.getEvent() != null);
        }
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    protected void createMessageSelectionGroup(Composite parent) {
        Composite messageSelectionGroup = new Composite(parent, 0);
        Label label = new Label(messageSelectionGroup, 0);
        label.setText(PROTOCOL_MESSAGES);
        messageSelectionGroup.setLayout((Layout)new GridLayout(1, true));
        messageSelectionGroup.setLayoutData((Object)new GridData(1808));
        this.fMessages = new CheckboxTreeViewer(messageSelectionGroup, 0);
        GridData msgGridData = new GridData(1808);
        msgGridData.heightHint = 150;
        msgGridData.widthHint = 250;
        this.fMessages.getTree().setLayoutData((Object)msgGridData);
        messageSelectionGroup.pack();
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent changeEvent) {
                Object obj = changeEvent.getElement();
                if (PortAndMsgReference.this.addMode) {
                    Object[] checkedElems;
                    if (obj instanceof AnyReceiveEvent) {
                        if (changeEvent.getChecked()) {
                            Object[] children = ((ITreeContentProvider)PortAndMsgReference.this.messageContentProvider).getChildren(null);
                            PortAndMsgReference.this.fMessages.setCheckedElements(children);
                            PortAndMsgReference.this.fMessages.setChecked(obj, true);
                        } else {
                            PortAndMsgReference.this.fMessages.setCheckedElements(new Object[0]);
                        }
                    } else if (!changeEvent.getChecked() && (checkedElems = PortAndMsgReference.this.fMessages.getCheckedElements()).length > 0 && checkedElems[0] instanceof AnyReceiveEvent) {
                        PortAndMsgReference.this.fMessages.setChecked(checkedElems[0], false);
                    }
                } else if (changeEvent.getChecked()) {
                    if (obj instanceof AnyReceiveEvent) {
                        Object[] children = ((ITreeContentProvider)PortAndMsgReference.this.messageContentProvider).getChildren(obj);
                        PortAndMsgReference.this.fMessages.setCheckedElements(children);
                    } else {
                        PortAndMsgReference.this.fMessages.setCheckedElements(new Object[0]);
                    }
                    PortAndMsgReference.this.fMessages.setChecked(obj, true);
                } else {
                    PortAndMsgReference.this.fMessages.setCheckedElements(new Object[0]);
                }
                PortAndMsgReference.this.save(SaveMode.MESSAGES);
                PortAndMsgReference.this.updateOkButtonState();
            }
        };
        this.fMessages.addCheckStateListener(checkListener);
    }

    public IAtomicOperationExecutor getOperationExecutor(Object context) {
        IAtomicOperationExecutor result = context instanceof IAdaptable ? (IAtomicOperationExecutor)((IAdaptable)context).getAdapter(IAtomicOperationExecutor.class) : (context != null ? (IAtomicOperationExecutor)Platform.getAdapterManager().getAdapter(context, IAtomicOperationExecutor.class) : null);
        if (result == null) {
            result = IAtomicOperationExecutor.DEFAULT;
        }
        return result;
    }

    public void initializeProviders(ILabelProvider labelProvider) {
        this.portContentProvider = new PortContentProvider(this.capsule);
        this.portLabelProvider = labelProvider;
        this.messageContentProvider = new ProtocolMsgContentProvider(this.trigger);
        this.messageLabelProvider = new ProtocolMsgLabelProvider(labelProvider);
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.dsListener);
        super.unhookDataSourceListener(oldInput);
    }

    protected void hookDataSourceListener(DataSource newInput) {
        newInput.addDataSourceListener(this.dsListener);
        super.hookDataSourceListener(newInput);
    }

    protected void setPortChecks() {
        this.fPorts.setAllChecked(false);
        for (Port existingPort : this.trigger.getPorts()) {
            this.fPorts.setChecked((Object)existingPort, true);
        }
    }

    protected void setMessageChecks() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Event event = PortAndMsgReference.this.trigger.getEvent();
                PortAndMsgReference.this.fMessages.setCheckedElements(new Object[0]);
                if (event != null) {
                    PortAndMsgReference.this.fMessages.expandAll();
                    if (event instanceof AnyReceiveEvent) {
                        Object[] children = ((ITreeContentProvider)PortAndMsgReference.this.messageContentProvider).getChildren((Object)event);
                        PortAndMsgReference.this.fMessages.setCheckedElements(children);
                    }
                    PortAndMsgReference.this.fMessages.setChecked((Object)event, true);
                }
            }
        });
    }

    protected void doBinding() {
        ModelElement triggerElement = this.input.getModelElement(this.propertyPath);
        ILabelProvider labelProvider = this.input.getLabelProvider(this.propertyPath);
        EObject triggerEObj = ((UMLModelElement)triggerElement).getSource();
        this.installChangeListeners();
        if (triggerEObj instanceof Trigger) {
            this.trigger = (Trigger)triggerEObj;
            this.transition = (Transition)this.trigger.getOwner();
            this.addMode = NewElementUtil.isCreatedElement((EObject)triggerEObj);
            if (this.transition == null) {
                CreationContext creationContext = (CreationContext)EcoreUtil.getExistingAdapter((Notifier)this.trigger, CreationContext.class);
                if (creationContext != null) {
                    this.transition = (Transition)creationContext.getCreationContextElement();
                }
                this.addMode = true;
            }
            Transition owner = this.transition;
            while (owner != null) {
                if (owner instanceof Class && !(owner instanceof Behavior)) {
                    this.capsule = (Class)owner;
                    break;
                }
                owner = owner.getOwner();
            }
            if (this.capsule != null) {
                this.domain = TransactionUtil.getEditingDomain((EObject)this.capsule);
                this.initializeProviders(labelProvider);
                this.fPorts.setContentProvider((IContentProvider)this.portContentProvider);
                this.fPorts.setLabelProvider((IBaseLabelProvider)this.portLabelProvider);
                this.fPorts.setInput((Object)this);
                this.setPortChecks();
                this.fMessages.setContentProvider((IContentProvider)this.messageContentProvider);
                this.fMessages.setLabelProvider((IBaseLabelProvider)this.messageLabelProvider);
                this.fMessages.setInput((Object)this);
                this.setMessageChecks();
            }
        }
        super.doBinding();
        this.updateOkButtonState();
    }

    static enum SaveMode {
        PORTS,
        MESSAGES,
        ADDITIONAL_TRIGGER;

    }
}

