/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.external;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrusrt.umlrt.uml.util.UMLRTResourcesUtil;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.PluginFinder;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTProfileMetadata;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.uml2.uml.UMLPlugin;
import org.osgi.framework.BundleContext;

public final class ExternalPackageManager
extends Plugin {
    public static final String ID = "org.eclipse.papyrusrt.xtumlrt.external";
    private static final ExternalPackageMetadata[] BUILT_IN_PACKAGES = new ExternalPackageMetadata[]{UMLRTProfileMetadata.INSTANCE, RTSModelLibraryMetadata.INSTANCE};
    private static final IStatus OK_STATUS = new Status(0, "org.eclipse.papyrusrt.xtumlrt", "ok");
    private static ExternalPackageManager instance;
    private static BundleContext context;
    private boolean standalone;
    private PluginFinder pluginFinder;
    private Map<String, ExternalPackageMetadata> requiredPackages;
    private Map<String, ExternalPackageMetadata> registeredPackages;
    private ResourceSet resourceSet;
    private boolean setup;

    private ExternalPackageManager() {
        this.reset();
    }

    public void reset() {
        this.standalone = false;
        this.pluginFinder = new PluginFinder(new String[0]);
        this.requiredPackages = new HashMap<String, ExternalPackageMetadata>();
        this.registeredPackages = new HashMap<String, ExternalPackageMetadata>();
        this.resourceSet = new ResourceSetImpl();
        this.setup = false;
        ExternalPackageMetadata[] externalPackageMetadataArray = BUILT_IN_PACKAGES;
        int n = BUILT_IN_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalPackageMetadata metadata = externalPackageMetadataArray[n2];
            this.addRequiredPackage(metadata);
            ++n2;
        }
    }

    public static ExternalPackageManager getInstance() {
        if (instance == null) {
            instance = new ExternalPackageManager();
        }
        return instance;
    }

    public static BundleContext getContext() {
        return context;
    }

    public PluginFinder getPluginFinder() {
        return this.pluginFinder;
    }

    public Map<String, ExternalPackageMetadata> getRegistry() {
        return this.registeredPackages;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public ExternalPackageMetadata getPackageMetadata(String packageId) {
        return this.registeredPackages.get(packageId);
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void start(BundleContext context) {
        ExternalPackageManager.context = context;
    }

    public void stop(BundleContext context) {
        ExternalPackageManager.context = null;
    }

    public void addRequiredPackage(ExternalPackageMetadata packageMetadata) {
        if (packageMetadata != null) {
            String key = packageMetadata.getPackageId();
            if (key != null && !key.isEmpty()) {
                if (this.registeredPackages.containsKey(key)) {
                    XTUMLRTLogger.warning((String)("Package '" + key + "' was already registered. The old registration will be overriden."));
                }
                this.requiredPackages.put(key, packageMetadata);
            } else {
                XTUMLRTLogger.warning((String)"Attempting to register a package with no ID.");
            }
        } else {
            XTUMLRTLogger.warning((String)"Attempting to register null as a package.");
        }
    }

    public IStatus setup() {
        IStatus success = OK_STATUS;
        if (!this.setup) {
            if (this.standalone) {
                UMLRTResourcesUtil.init((ResourceSet)this.resourceSet);
            }
            this.searchPlugins();
            for (String requiredPackageId : this.requiredPackages.keySet()) {
                ExternalPackageMetadata metadata = this.requiredPackages.get(requiredPackageId);
                boolean loaded = this.loadPackage(metadata);
                if (!loaded) {
                    XTUMLRTLogger.warning((String)("Unable to load package: '" + requiredPackageId + "'"));
                    continue;
                }
                boolean registered = this.registerPackage(metadata);
                if (!registered) {
                    XTUMLRTLogger.warning((String)("Unable to register package: '" + requiredPackageId + "'"));
                    continue;
                }
                metadata.setup();
            }
            this.setup = true;
        }
        return success;
    }

    private void searchPlugins() {
        if (!this.pluginFinder.isResolved()) {
            for (String pkgId : this.requiredPackages.keySet()) {
                this.pluginFinder.addRequiredPlugin(pkgId);
            }
            this.pluginFinder.resolve(this.standalone);
            this.pluginFinder.logResolvedMappings();
        }
    }

    private boolean loadPackage(ExternalPackageMetadata metadata) {
        boolean success = false;
        URI pathmap = metadata.getPathmapURI();
        Resource existingResource = this.resourceSet.getResource(pathmap, !this.standalone);
        if (existingResource != null) {
            this.loadResourceContents(existingResource, metadata);
            success = true;
        } else {
            String packageId = metadata.getPackageId();
            if (this.pluginFinder.found(packageId)) {
                this.resolvePackageLocation(metadata);
                URI fullURI = metadata.getPackageLocationURI();
                Resource resource = this.resourceSet.getResource(fullURI, true);
                this.loadResourceContents(resource, metadata);
                success = true;
            } else {
                XTUMLRTLogger.warning((String)("Unable to find plugin with id '" + packageId + "'"));
            }
        }
        return success;
    }

    private void loadResourceContents(Resource existingResource, ExternalPackageMetadata metadata) {
        metadata.setResource(existingResource);
        EList contents = existingResource.getContents();
        EObject root = (EObject)contents.get(0);
        metadata.setRoot(root);
    }

    private void resolvePackageLocation(ExternalPackageMetadata metadata) {
        String packageLoc;
        String resolvedPath = null;
        String pkgId = metadata.getPackageId();
        if (pkgId != null && (packageLoc = this.pluginFinder.get(pkgId)) != null) {
            String pkgModel;
            Path path = this.parsePath(packageLoc);
            String subdir = metadata.getFolderName();
            if (subdir != null) {
                path = path.resolve(subdir);
            }
            if ((pkgModel = metadata.getFileName()) != null) {
                path = path.resolve(pkgModel);
            }
            resolvedPath = path.toUri().toString();
        }
        metadata.setPackageLocation(resolvedPath);
    }

    private Path parsePath(String path) {
        Path result = null;
        java.net.URI uri = null;
        try {
            uri = new java.net.URI(path);
            if (uri.getScheme().equals("jar")) {
                FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
        }
        catch (IOException | URISyntaxException | FileSystemAlreadyExistsException exception) {}
        result = Paths.get(uri);
        return result;
    }

    private boolean registerPackage(ExternalPackageMetadata metadata) {
        boolean success = false;
        if (this.standalone) {
            switch (metadata.getKind()) {
                case Package: {
                    success = this.doRegisterNormalPackage(metadata);
                    break;
                }
                case Library: {
                    success = this.doRegisterLibrary(metadata);
                    break;
                }
                case Profile: {
                    success = this.doRegisterProfile(metadata);
                    break;
                }
                default: {
                    success = this.doRegisterNormalPackage(metadata);
                    break;
                }
            }
        } else {
            success = true;
        }
        if (success) {
            this.registeredPackages.put(metadata.getPackageId(), metadata);
        }
        return success;
    }

    private boolean doRegisterNormalPackage(ExternalPackageMetadata metadata) {
        URI pathmapUri = metadata.getPathmapURI();
        URI packageLocUri = metadata.getPackageLocationURI();
        this.resourceSet.getURIConverter().getURIMap().put(pathmapUri, packageLocUri);
        String nsUri = metadata.getNsURI();
        EPackage pkg = metadata.getEPackage();
        if (nsUri != null && pkg != null) {
            this.resourceSet.getPackageRegistry().put((Object)nsUri, (Object)pkg);
        }
        return true;
    }

    private boolean doRegisterLibrary(ExternalPackageMetadata metadata) {
        return this.doRegisterNormalPackage(metadata);
    }

    private boolean doRegisterProfile(ExternalPackageMetadata metadata) {
        boolean success = false;
        success = this.doRegisterNormalPackage(metadata);
        if (success) {
            String nsUri = metadata.getNsURI();
            URI rootUri = metadata.getRootURI();
            if (nsUri != null && rootUri != null) {
                UMLPlugin.getEPackageNsURIToProfileLocationMap().put(nsUri, rootUri);
                success = true;
            }
        }
        return success;
    }
}

