/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.external;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class PluginFinder {
    private static final String JAR_EXTENSION = ".jar";
    private static final String PROJ_EXTENSION = ".project";
    private static List<String> searchPaths = new ArrayList<String>();
    private final Map<PluginData, Boolean> requiredMappings;
    private final Map<PluginData, String> resolvedMappings = new HashMap<PluginData, String>();

    public PluginFinder(String ... requiredProjects) {
        this.requiredMappings = new HashMap<PluginData, Boolean>();
        String[] stringArray = requiredProjects;
        int n = requiredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredProject = stringArray[n2];
            this.addRequiredProject(requiredProject);
            ++n2;
        }
    }

    public void addRequiredPlugin(String name) {
        this.addRequiredPlugin(name, null);
    }

    public void addRequiredPlugin(String name, String version) {
        if (!this.resolvedMappings.isEmpty()) {
            throw new IllegalStateException("Cannot addRequiredProject to PluginFinder after resolve()");
        }
        if (name != null) {
            this.requiredMappings.put(new PluginData(name, version), Boolean.FALSE);
        }
    }

    public void addRequiredProject(String name) {
        this.addRequiredPlugin(name, null);
    }

    public static void addSearchPath(Path path) {
        String pathStr;
        if (path != null && !searchPaths.contains(pathStr = path.toAbsolutePath().toString())) {
            searchPaths.add(pathStr);
        }
    }

    public static void addSearchPaths(String paths) {
        String[] entries;
        String[] stringArray = entries = paths.split(":");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            PluginFinder.addSearchPath(Paths.get(entry, new String[0]));
            ++n2;
        }
    }

    public boolean allFound() {
        boolean found = true;
        for (Boolean b : this.requiredMappings.values()) {
            if (b.booleanValue()) continue;
            found = false;
            break;
        }
        return found;
    }

    public String get(String pluginId) {
        String latestVersion = null;
        String resolvedPath = null;
        for (Map.Entry<PluginData, String> mapping : this.resolvedMappings.entrySet()) {
            PluginData found = mapping.getKey();
            String path = mapping.getValue();
            if (!found.getName().equals(pluginId)) continue;
            if (found.getVersion() == null) {
                resolvedPath = path;
                break;
            }
            if (latestVersion != null && found.getVersion().compareTo(latestVersion) <= 0) continue;
            latestVersion = found.getVersion();
            resolvedPath = path;
        }
        return resolvedPath;
    }

    public String get(String pluginId, String version) {
        PluginData plugin = new PluginData(pluginId, version);
        return this.resolvedMappings.get(plugin);
    }

    public boolean found(String pluginId) {
        return this.get(pluginId) != null;
    }

    public boolean found(String pluginId, String version) {
        return this.get(pluginId, version) != null;
    }

    public boolean isResolved() {
        return !this.resolvedMappings.isEmpty();
    }

    public void reset() {
        this.resolvedMappings.clear();
        this.requiredMappings.clear();
    }

    private Path getManifestPath(File file) {
        Path path = file.toPath();
        Path mfpath = null;
        if (path != null && !path.toString().endsWith(JAR_EXTENSION)) {
            mfpath = path.resolve("META-INF").resolve("MANIFEST.MF");
        }
        return mfpath;
    }

    private String getSymbolicName(Manifest manifest) {
        int indexOf;
        String name;
        String symName = null;
        if (manifest != null && (name = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null && (indexOf = name.indexOf(59)) > 0) {
            symName = name.substring(0, indexOf);
        }
        return symName;
    }

    private String getVersion(Manifest manifest) {
        String version = null;
        if (manifest != null) {
            version = manifest.getMainAttributes().getValue("Bundle-Version");
        }
        return version;
    }

    private boolean isJarBundle(File file) {
        boolean result = false;
        if (file.exists() && !file.isDirectory()) {
            Path path = file.toPath();
            result = path != null && path.toString().endsWith(JAR_EXTENSION);
        }
        return result;
    }

    private boolean isNonJarBundle(File file) {
        boolean result = false;
        if (file.exists() && file.isDirectory()) {
            Path path = this.getManifestPath(file);
            result = path != null && Files.exists(path, new LinkOption[0]);
        }
        return result;
    }

    private boolean isRequired(PluginData plugin) {
        boolean isReq = false;
        for (PluginData required : this.requiredMappings.keySet()) {
            if (!required.getName().equals(plugin.getName()) || required.getVersion() != null && !required.getVersion().equals(plugin.getVersion())) continue;
            isReq = true;
            break;
        }
        return isReq;
    }

    private boolean registerFromManifest(File f, Manifest manifest, String type) {
        String version;
        PluginData plugin;
        String name;
        boolean result = false;
        if (manifest != null && (name = this.getSymbolicName(manifest)) != null && this.isRequired(plugin = new PluginData(name, version = this.getVersion(manifest)))) {
            File canonical = null;
            try {
                canonical = new File(f.getCanonicalPath());
            }
            catch (IOException iOException) {
                canonical = f;
            }
            String uri = String.valueOf(type) + (!"".equals(type) ? ":" : "") + canonical.toURI() + ("jar".equals(type) ? "!/" : "");
            this.resolvedMappings.put(plugin, uri);
            this.requiredMappings.put(plugin, Boolean.TRUE);
            result = true;
        }
        return result;
    }

    private boolean registerJarBundle(File f) throws IOException {
        boolean result = false;
        try (JarFile jarFile = new JarFile(f);){
            Manifest manifest = jarFile.getManifest();
            result = this.registerFromManifest(f, manifest, "jar");
        }
        return result;
    }

    private boolean registerNonJarBundle(File file) throws IOException {
        boolean result = false;
        Path path = this.getManifestPath(file);
        if (path != null) {
            try (FileInputStream fis = null;){
                try {
                    fis = new FileInputStream(path.toAbsolutePath().toString());
                    Manifest manifest = new Manifest(fis);
                    result = this.registerFromManifest(file, manifest, "");
                }
                catch (IOException iOException) {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
        }
        return result;
    }

    private boolean registerProject(File file) {
        boolean result;
        block16: {
            result = false;
            FileInputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(file);
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
                    String project = document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
                    PluginData plugin = new PluginData(project, null);
                    if (this.requiredMappings.keySet().contains(plugin)) {
                        this.resolvedMappings.put(plugin, String.valueOf(file.getParentFile().getCanonicalPath()) + File.separator);
                        result = true;
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public void resolve(boolean standalone) {
        if (standalone) {
            this.resolveInStandalone();
        } else {
            this.resolveInEclipse();
        }
    }

    private void resolveInEclipse() {
        for (PluginData requiredPlugin : this.requiredMappings.keySet()) {
            String requiredPluginName = requiredPlugin.getName();
            String requiredPluginVersion = requiredPlugin.getVersion();
            Bundle bundle = null;
            if (requiredPluginVersion == null) {
                bundle = Platform.getBundle((String)requiredPlugin.getName());
            } else {
                Bundle[] bundles = Platform.getBundles((String)requiredPlugin.getName(), (String)requiredPluginVersion);
                if (bundles != null) {
                    Bundle[] bundleArray = bundles;
                    int n = bundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Bundle candidate = bundleArray[n2];
                        if (candidate.getSymbolicName().equals(requiredPluginName) && candidate.getVersion().toString().equals(requiredPluginVersion)) {
                            bundle = candidate;
                        }
                        ++n2;
                    }
                    if (bundle == null) {
                        bundle = bundles[0];
                    }
                }
            }
            if (bundle == null) continue;
            try {
                URL url = bundle.getEntry("/");
                URI uri = FileLocator.resolve((URL)url).toURI();
                String uriStr = uri.toString();
                this.resolvedMappings.put(requiredPlugin, uriStr);
                this.requiredMappings.put(requiredPlugin, Boolean.TRUE);
            }
            catch (IOException | URISyntaxException exception) {
                XTUMLRTLogger.warning((String)("Unable to find required plugin or project: '" + requiredPlugin.toString() + "'"));
            }
        }
    }

    private void resolveInStandalone() {
        String property = System.getProperty("java.class.path");
        if (property == null) {
            return;
        }
        String separator = System.getProperty("path.separator");
        String[] cpEntries = property.split(separator);
        ArrayList<String> entries = new ArrayList<String>();
        entries.addAll(searchPaths);
        entries.addAll(Arrays.asList(cpEntries));
        for (String entry : entries) {
            File fileEntry = new File(entry);
            try {
                File f = fileEntry.getCanonicalFile();
                if (!f.exists()) continue;
                if (this.isJarBundle(f)) {
                    this.registerJarBundle(f);
                } else if (this.isNonJarBundle(f)) {
                    this.registerNonJarBundle(f);
                } else if (f.isDirectory()) {
                    this.scanFolder(f, new HashSet<String>(), 0);
                } else {
                    File parentFile = f.getParentFile();
                    File dotProject = new File(parentFile, PROJ_EXTENSION);
                    if (dotProject.exists()) {
                        this.registerProject(dotProject);
                    }
                }
                if (!this.allFound()) continue;
                break;
            }
            catch (Exception exception) {}
        }
    }

    private boolean scanFolder(File f, Set<String> alreadyVisited, int depth) throws IOException {
        if (!alreadyVisited.add(f.getCanonicalPath())) {
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists()) {
                    if (this.isJarBundle(file)) {
                        this.registerJarBundle(file);
                    } else if (this.isNonJarBundle(file)) {
                        this.registerNonJarBundle(file);
                    } else if (PROJ_EXTENSION.equals(file.getName())) {
                        dotProject = file;
                    } else if (file.isDirectory() && depth < 2 && !file.getName().startsWith(".")) {
                        containsProject |= this.scanFolder(file, alreadyVisited, depth + 1);
                    }
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }

    public void logResolvedMappings() {
        XTUMLRTLogger.info((String)"resolved mapping start");
        System.out.println("resolved mapping start");
        for (Map.Entry<PluginData, String> entry : this.resolvedMappings.entrySet()) {
            XTUMLRTLogger.info((String)(entry.getKey() + " |-> " + entry.getValue()));
            System.out.println(entry.getKey() + " |-> " + entry.getValue());
        }
        XTUMLRTLogger.info((String)"resolved mapping end");
        System.out.println("resolved mapping end");
    }

    static String indent(int n) {
        StringBuilder r = new StringBuilder();
        int i = 0;
        while (i < n) {
            r.append(' ');
            ++i;
        }
        return r.toString();
    }

    private static class PluginData {
        private String name;
        private String version;

        PluginData(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof PluginData)) {
                return false;
            }
            return ((PluginData)other).getName().equals(this.getName()) && (this.getVersion() == null || ((PluginData)other).getVersion() == null || ((PluginData)other).getVersion().equals(this.getVersion()));
        }

        public String toString() {
            return "( " + this.getName() + ", " + this.getVersion() + ")";
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

