/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.to.uml.umlrt;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.EObjectListValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationModel;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.sequence.CreateSequenceDiagramCommand;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrusrt.codegen.cpp.AnsiCLibraryMetadata;
import org.eclipse.papyrusrt.codegen.cpp.profile.facade.RTCppPropertiesProfileMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageManager;
import org.eclipse.papyrusrt.xtumlrt.external.ExternalPackageMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTProfileMetadata;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTSMProfileMetadata;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLUtil;

public final class Xtumlrt2UMLTranslatorUtils {
    private static final ExternalPackageManager EXT_PKG_MGR = ExternalPackageManager.getInstance();
    private static final ExternalPackageMetadata[] REQUIRED_PACKAGES = new ExternalPackageMetadata[]{RTCppPropertiesProfileMetadata.INSTANCE, AnsiCLibraryMetadata.INSTANCE};
    private static final String PATHMAP_UML_PRIMITIVE_TYPES_LIBRARY = "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml";
    private static final String UMLRT_PROFILE_PATHMAP = UMLRTProfileMetadata.INSTANCE.getPathmap();
    private static final String UMLRT_SM_PROFILE_PATHMAP = UMLRTSMProfileMetadata.INSTANCE.getPathmap();
    private static final String RTCPP_PROFILE_PATHMAP = "pathmap://UMLRT_CPP/RTCppProperties.profile.uml";
    private static final String ANSI_C_LIB_ID = "org.eclipse.papyrus.designer.languages.cpp.library";
    private static final String ANSI_C_LIB_PATH = "pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml";
    private static final String RTS_MODLIB_ID = RTSModelLibraryMetadata.INSTANCE.getPackageId();
    private static final String RTS_MODLIB_PATH = RTSModelLibraryMetadata.INSTANCE.getPathmap();
    private static final String DIAGRAM_CATEGORY_ID = "UMLRT";
    private static String[] requiredBuiltInProfiles = new String[]{UMLRT_PROFILE_PATHMAP, UMLRT_SM_PROFILE_PATHMAP, "pathmap://UMLRT_CPP/RTCppProperties.profile.uml"};
    private static final ResourceSetImpl RSET = new ResourceSetImpl();
    private static Resource UMLPrimitiveTypeResource;
    private static Resource AnsiCLibraryResource;
    private static Resource RTSLibraryResource;
    private static Map<String, Profile> profiles;
    private static boolean initialized;

    static {
        profiles = new HashMap<String, Profile>();
        initialized = false;
        Xtumlrt2UMLTranslatorUtils.addBuiltInProfiles();
    }

    private Xtumlrt2UMLTranslatorUtils() {
    }

    public static void addRequiredProfile(String pathmap) {
        if (pathmap != null && !pathmap.isEmpty() && !profiles.containsKey(pathmap)) {
            profiles.put(pathmap, null);
        }
    }

    public static Profile getProfile(String pathmap) {
        return profiles.get(pathmap);
    }

    private static Profile loadAndApplyProfile(String pathmap, Package pakage) {
        Profile profile = null;
        try {
            URI profileURI = URI.createURI((String)pathmap);
            profile = (Profile)PackageUtil.loadPackage((URI)profileURI, (ResourceSet)pakage.eResource().getResourceSet());
            if (profile != null) {
                PackageUtil.applyProfile((Package)pakage, (Profile)profile, (boolean)true);
                profiles.put(pathmap, profile);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            XTUMLRTLogger.warning((String)("Attention: the requested profile for pathmap '" + pathmap + "' could not be loaded."));
        }
        return profile;
    }

    private static void loadAndApplyRequiredProfiles(Package pakage) {
        for (String pathmap : profiles.keySet()) {
            Xtumlrt2UMLTranslatorUtils.loadAndApplyProfile(pathmap, pakage);
        }
    }

    private static void addBuiltInProfiles() {
        String[] stringArray = requiredBuiltInProfiles;
        int n = requiredBuiltInProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            String pathmap = stringArray[n2];
            Xtumlrt2UMLTranslatorUtils.addRequiredProfile(pathmap);
            ++n2;
        }
    }

    public static void initializeRequiredLibraries() {
        Map registry;
        if (initialized) {
            return;
        }
        ExternalPackageMetadata[] externalPackageMetadataArray = REQUIRED_PACKAGES;
        int n = REQUIRED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalPackageMetadata metadata = externalPackageMetadataArray[n2];
            EXT_PKG_MGR.addRequiredPackage(metadata);
            ++n2;
        }
        EXT_PKG_MGR.setup();
        UMLPrimitiveTypeResource = EXT_PKG_MGR.getResourceSet().getResource(URI.createURI((String)PATHMAP_UML_PRIMITIVE_TYPES_LIBRARY), true);
        String ansiCLibPath = ANSI_C_LIB_PATH;
        String rtsLibPath = RTS_MODLIB_PATH;
        if (EXT_PKG_MGR != null && (registry = EXT_PKG_MGR.getRegistry()) != null) {
            String pathmap;
            ExternalPackageMetadata rtsLibMetadata;
            String pathmap2;
            ExternalPackageMetadata ansiCmetadata = (ExternalPackageMetadata)registry.get(ANSI_C_LIB_ID);
            if (ansiCmetadata != null && (pathmap2 = ansiCmetadata.getPathmap()) != null && !pathmap2.isEmpty()) {
                ansiCLibPath = pathmap2;
            }
            if ((rtsLibMetadata = (ExternalPackageMetadata)registry.get(RTS_MODLIB_ID)) != null && (pathmap = rtsLibMetadata.getPathmap()) != null && !pathmap.isEmpty()) {
                rtsLibPath = pathmap;
            }
        }
        AnsiCLibraryResource = RSET.getResource(URI.createURI((String)ansiCLibPath), true);
        RTSLibraryResource = RSET.getResource(URI.createURI((String)rtsLibPath), true);
        initialized = true;
    }

    public static int overwrite() {
        MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell(), 296);
        dialog.setText("Warning");
        dialog.setMessage("Do you want to overwrite the existing model?");
        int result = dialog.open();
        if (result == 32) {
            return 0;
        }
        return 8;
    }

    public static boolean modelExists(URI uri) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        return file.exists();
    }

    public static ModelSet createPapyrusModel(ServicesRegistry registry, final URI uri) throws ServiceException, BackboneException, IOException {
        final ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
        TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(domain){

            protected void doExecute() {
                modelSet.createModels(uri);
            }
        };
        domain.getCommandStack().execute((Command)command);
        Xtumlrt2UMLTranslatorUtils.initRegistry(registry);
        Xtumlrt2UMLTranslatorUtils.initDomainModel(modelSet);
        return modelSet;
    }

    public static void initDomainModel(final ModelSet modelSet) throws BackboneException, IOException {
        TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
        String[] viewPointIds = new String[]{"org.eclipse.papyrusrt.umlrt.viewpoint.basic"};
        try {
            ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils(modelSet);
            Command command = helper.createNewModel("org.eclipse.papyrusrt.umlrt.architecture", viewPointIds);
            modelSet.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        catch (Exception exception) {}
        RecordingCommand smcommand = new RecordingCommand(domain){

            protected void doExecute() {
                try {
                    Package model = (Package)((UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).lookupRoot();
                    Xtumlrt2UMLTranslatorUtils.loadAndApplyRequiredProfiles(model);
                }
                catch (NotFoundException e) {
                    XTUMLRTLogger.error((String)"Failed to initialize domain model", (Throwable)e);
                }
            }
        };
        domain.getCommandStack().execute((Command)smcommand);
        modelSet.save((IProgressMonitor)new NullProgressMonitor());
    }

    public static void initRegistry(ServicesRegistry registry) {
        try {
            registry.startRegistry();
            registry.getService(IPageManager.class);
        }
        catch (ServiceException serviceException) {}
    }

    public static ServicesRegistry createServicesRegistry() {
        ExtensionServicesRegistry registry = null;
        try {
            registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
            registry.startServicesByClassKeys(new java.lang.Class[]{ModelSet.class});
        }
        catch (ServiceException e) {
            XTUMLRTLogger.error((String)"Failed to create service registry", (Throwable)e);
        }
        return registry;
    }

    public static EObject applyStereotype(Element element, EClass definition) {
        return Xtumlrt2UMLTranslatorUtils.applyStereotype(element, element, definition);
    }

    public static EObject applyStereotype(Element element, Element context, EClass definition) {
        return UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)context).applyStereotype(element, definition);
    }

    public static EObject getPrimitiveType(String type) {
        Collection results = UMLUtil.findNamedElements((Resource)AnsiCLibraryResource, (String)("AnsiCLibrary::" + type));
        if (!results.isEmpty()) {
            return (EObject)results.iterator().next();
        }
        results = UMLUtil.findNamedElements((Resource)UMLPrimitiveTypeResource, (String)("PrimitiveTypes::" + type));
        if (!results.isEmpty()) {
            return (EObject)results.iterator().next();
        }
        return null;
    }

    public static EObject getRTSProtocol(String name) {
        Collection results = UMLUtil.findNamedElements((Resource)RTSLibraryResource, (String)("UMLRT-RTS::" + name + "::" + name));
        if (!results.isEmpty()) {
            return (EObject)results.iterator().next();
        }
        return null;
    }

    public static ModelSet getModelSetFromEObject(EObject eobject) {
        ServicesRegistry registry;
        ModelSet result = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(eobject);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return result;
        }
        try {
            result = (ModelSet)registry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return result;
        }
        return result;
    }

    public static Set<Interaction> getAllInteractions(Model model) {
        HashSet<Interaction> interactions = new HashSet<Interaction>();
        TreeIterator itor = model.eAllContents();
        while (itor.hasNext()) {
            EObject next = (EObject)itor.next();
            if (next instanceof Interaction) {
                interactions.add((Interaction)next);
            }
            if (next instanceof Package || next instanceof Class) continue;
            itor.prune();
        }
        return interactions;
    }

    public static void createSequenceDiagrams(Model model) {
        Set<Interaction> interactions = Xtumlrt2UMLTranslatorUtils.getAllInteractions(model);
        if (interactions.isEmpty()) {
            return;
        }
        ModelSet modelSet = Xtumlrt2UMLTranslatorUtils.getModelSetFromEObject((EObject)model);
        if (modelSet == null) {
            return;
        }
        ViewPrototype seqDiagPrototype = null;
        Collection prototypes = PolicyChecker.getFor((EObject)model).getPrototypesFor((EObject)model);
        for (ViewPrototype prototype : prototypes) {
            PapyrusRepresentationKind view = prototype.getRepresentationKind();
            if (!(view instanceof PapyrusDiagram) || !"Sequence Diagram".equals(prototype.getLabel())) continue;
            seqDiagPrototype = prototype;
            break;
        }
        if (seqDiagPrototype == null) {
            return;
        }
        CreateSequenceDiagramCommand cmd = new CreateSequenceDiagramCommand();
        EmbeddedStyleSheet es = StylesheetsFactory.eINSTANCE.createEmbeddedStyleSheet();
        es.setLabel("CanonicalDiagram");
        es.setContent("{canonical:true;}");
        CSSNotationModel notation = (CSSNotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        notation.getResource().getContents().add((Object)es);
        for (Interaction i : interactions) {
            CSSDiagram di = (CSSDiagram)cmd.createDiagram(modelSet, (EObject)i, (EObject)i, seqDiagPrototype, "seqDiagram", false);
            if (di == null) continue;
            EObjectListValueStyle valuestyle = (EObjectListValueStyle)di.createStyle(NotationPackage.Literals.EOBJECT_LIST_VALUE_STYLE);
            valuestyle.setName("css_stylesheets");
            valuestyle.getEObjectListValue().add((Object)es);
        }
    }
}

