/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.AnnotationParameter;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonFactory;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XTUMLRTAnnotations {
    public static final String ANN_EXCLUSION = "Excluded";
    public static final String ANN_PARAM_EXCLUDED = "excluded";
    private static final HashMap<CommonElement, EList<EObject>> annotationsMap = new HashMap();

    public static void setAnnotations(Element umlElement, CommonElement element) {
        if (umlElement == null || element == null || umlElement.getApplicableStereotypes() == null) {
            return;
        }
        Object _xifexpression = null;
        EList _stereotypeApplications = umlElement.getStereotypeApplications();
        boolean _tripleNotEquals = _stereotypeApplications != null;
        _xifexpression = _tripleNotEquals ? umlElement.getStereotypeApplications() : new BasicEList();
        EList stereotypeApplications = _xifexpression;
        annotationsMap.put(element, (EList<EObject>)stereotypeApplications);
        if (element instanceof NamedElement) {
            XTUMLRTAnnotations.translateStereotypes((NamedElement)element, (Iterable<EObject>)stereotypeApplications);
        }
    }

    public static EObject getAnnotation(CommonElement element, final String name) {
        if (element == null || name == null) {
            return null;
        }
        if (element instanceof NamedElement) {
            EList<EObject> otherAnnotations;
            Functions.Function1<Annotation, Boolean> _function;
            Annotation annotation;
            EList annotations = ((NamedElement)element).getAnnotations();
            if (annotations != null && !annotations.isEmpty() && (annotation = (Annotation)IterableExtensions.findFirst((Iterable)annotations, (Functions.Function1)(_function = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    String _annotationName = XTUMLRTAnnotations.getAnnotationName((EObject)it);
                    return Objects.equal((Object)_annotationName, (Object)name);
                }
            }))) != null) {
                return annotation;
            }
            boolean _containsKey = annotationsMap.containsKey(element);
            if (_containsKey && (otherAnnotations = annotationsMap.get(element)) != null) {
                Functions.Function1<EObject, Boolean> _function_1 = new Functions.Function1<EObject, Boolean>(){

                    public Boolean apply(EObject it) {
                        String _annotationName = XTUMLRTAnnotations.getAnnotationName(it);
                        return Objects.equal((Object)_annotationName, (Object)name);
                    }
                };
                return (EObject)IterableExtensions.findFirst(otherAnnotations, (Functions.Function1)_function_1);
            }
        }
        return null;
    }

    public static EList<EObject> getAllAnnotations(CommonElement element) {
        return annotationsMap.get(element);
    }

    protected static Object _getProperty(CommonElement element, String annotation, String property) {
        if (element == null || annotation == null || property == null) {
            return null;
        }
        Object propertyValue = null;
        if (element instanceof NamedElement) {
            Object _findProperty;
            EList annotations = ((NamedElement)element).getAnnotations();
            propertyValue = _findProperty = XTUMLRTAnnotations.findProperty(annotation, property, (Iterable<? extends EObject>)annotations);
        }
        if (propertyValue == null && annotationsMap.containsKey(element)) {
            Object _findProperty_1;
            EList<EObject> elemStereotypes = annotationsMap.get(element);
            propertyValue = _findProperty_1 = XTUMLRTAnnotations.findProperty(annotation, property, elemStereotypes);
        }
        return propertyValue;
    }

    protected static Object _findProperty(final String annotation, String property, Iterable<? extends EObject> annotations) {
        Object _xifexpression = null;
        if (annotations != null && !IterableExtensions.isEmpty(annotations)) {
            Object _xblockexpression = null;
            Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                public Boolean apply(EObject it) {
                    String _annotationName = XTUMLRTAnnotations.getAnnotationName(it);
                    return Objects.equal((Object)_annotationName, (Object)annotation);
                }
            };
            EObject theAnnotation = (EObject)IterableExtensions.findFirst(annotations, (Functions.Function1)_function);
            Object _xifexpression_1 = null;
            if (theAnnotation != null) {
                _xifexpression_1 = XTUMLRTAnnotations.getAnnotationProperty(theAnnotation, property);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected static Object _getProperty(CommonElement element, Collection<String> annotations, String property) {
        if (annotations == null || property == null) {
            return null;
        }
        Object propertyValue = null;
        if (element instanceof NamedElement) {
            Object _findProperty;
            EList annotationsList = ((NamedElement)element).getAnnotations();
            propertyValue = _findProperty = XTUMLRTAnnotations.findProperty(annotations, property, (Iterable<? extends EObject>)annotationsList);
        }
        if (propertyValue == null && annotationsMap.containsKey(element)) {
            Object _findProperty_1;
            EList<EObject> annotationsList_1 = annotationsMap.get(element);
            propertyValue = _findProperty_1 = XTUMLRTAnnotations.findProperty(annotations, property, annotationsList_1);
        }
        return propertyValue;
    }

    protected static Object _findProperty(final Collection<String> stereotypes, String property, Iterable<? extends EObject> annotations) {
        Object _xifexpression = null;
        if (annotations != null && !IterableExtensions.isEmpty(annotations)) {
            Object _xblockexpression = null;
            Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                public Boolean apply(EObject it) {
                    String _annotationName = XTUMLRTAnnotations.getAnnotationName(it);
                    return stereotypes.contains(_annotationName);
                }
            };
            EObject theAnnotation = (EObject)IterableExtensions.findFirst(annotations, (Functions.Function1)_function);
            Object _xifexpression_1 = null;
            if (theAnnotation != null) {
                _xifexpression_1 = XTUMLRTAnnotations.getAnnotationProperty(theAnnotation, property);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected static String _getAnnotationName(Annotation annotation) {
        return annotation.getName();
    }

    protected static String _getAnnotationName(Stereotype stereotype) {
        EClass _eClass = stereotype.eClass();
        return _eClass.getName();
    }

    protected static String _getAnnotationName(EObject eobj) {
        EClass _eClass = eobj.eClass();
        return _eClass.getName();
    }

    protected static Object _getAnnotationProperty(Annotation annotation, final String property) {
        Object _xblockexpression = null;
        EList _parameters = null;
        if (annotation != null) {
            _parameters = annotation.getParameters();
        }
        AnnotationParameter _findFirst = null;
        if (_parameters != null) {
            Functions.Function1<AnnotationParameter, Boolean> _function = new Functions.Function1<AnnotationParameter, Boolean>(){

                public Boolean apply(AnnotationParameter it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)property);
                }
            };
            _findFirst = (AnnotationParameter)IterableExtensions.findFirst((Iterable)_parameters, (Functions.Function1)_function);
        }
        AnnotationParameter param = _findFirst;
        Object _value = null;
        if (param != null) {
            _value = param.getValue();
        }
        _xblockexpression = _value;
        return _xblockexpression;
    }

    protected static Object _getAnnotationProperty(Stereotype stereotype, final String property) {
        Object _xblockexpression = null;
        EClass _eClass = null;
        if (stereotype != null) {
            _eClass = stereotype.eClass();
        }
        EList _eAllStructuralFeatures = null;
        if (_eClass != null) {
            _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
        }
        EStructuralFeature _findFirst = null;
        if (_eAllStructuralFeatures != null) {
            Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)property);
                }
            };
            _findFirst = (EStructuralFeature)IterableExtensions.findFirst((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        }
        EStructuralFeature feature = _findFirst;
        Object _xifexpression = null;
        if (feature != null) {
            Object _eGet = null;
            if (stereotype != null) {
                _eGet = stereotype.eGet(feature);
            }
            _xifexpression = _eGet;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected static Object _getAnnotationProperty(EObject eobj, final String property) {
        Object _xblockexpression = null;
        EClass _eClass = null;
        if (eobj != null) {
            _eClass = eobj.eClass();
        }
        EList _eAllStructuralFeatures = null;
        if (_eClass != null) {
            _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
        }
        EStructuralFeature _findFirst = null;
        if (_eAllStructuralFeatures != null) {
            Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)property);
                }
            };
            _findFirst = (EStructuralFeature)IterableExtensions.findFirst((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        }
        EStructuralFeature feature = _findFirst;
        Object _xifexpression = null;
        if (feature != null) {
            Object _eGet = null;
            if (eobj != null) {
                _eGet = eobj.eGet(feature);
            }
            _xifexpression = _eGet;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected static void translateStereotypes(NamedElement element, Iterable<EObject> stereotypeApplications) {
        for (EObject stereotypeApplication : stereotypeApplications) {
            boolean _not;
            Functions.Function1<Annotation, Boolean> _function;
            EClass stereotype = stereotypeApplication.eClass();
            if (!(stereotype instanceof Stereotype)) continue;
            final String stereotypeName = stereotype.getName();
            EList currentAnnotations = element.getAnnotations();
            boolean _exists = IterableExtensions.exists((Iterable)currentAnnotations, (Functions.Function1)(_function = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)stereotypeName);
                }
            }));
            boolean bl = _not = !_exists;
            if (!_not) continue;
            Annotation newAnnotation = CommonFactory.eINSTANCE.createAnnotation();
            newAnnotation.setName(stereotypeName);
            EList _attributes = ((Stereotype)stereotype).getAttributes();
            for (Property stereotypeProperty : _attributes) {
                String stereotypePropertyName = stereotypeProperty.getName();
                AnnotationParameter newAnnotationParameter = CommonFactory.eINSTANCE.createAnnotationParameter();
                newAnnotationParameter.setName(stereotypePropertyName);
                Object value = XTUMLRTAnnotations.getAnnotationProperty((EObject)stereotype, stereotypePropertyName);
                String _xifexpression = null;
                _xifexpression = value instanceof String ? (String)value : "";
                newAnnotationParameter.setValue((Object)_xifexpression);
            }
            EList _annotations = element.getAnnotations();
            _annotations.add((Object)newAnnotation);
        }
    }

    public static Object getProperty(CommonElement element, Object annotation, String property) {
        if (annotation instanceof String) {
            return XTUMLRTAnnotations._getProperty(element, (String)annotation, property);
        }
        if (annotation instanceof Collection) {
            return XTUMLRTAnnotations._getProperty(element, (Collection)annotation, property);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, annotation, property).toString());
    }

    protected static Object findProperty(Object annotation, String property, Iterable<? extends EObject> annotations) {
        if (annotation instanceof String) {
            return XTUMLRTAnnotations._findProperty((String)annotation, property, annotations);
        }
        if (annotation instanceof Collection) {
            return XTUMLRTAnnotations._findProperty((Collection)annotation, property, annotations);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(annotation, property, annotations).toString());
    }

    protected static String getAnnotationName(EObject stereotype) {
        if (stereotype instanceof Stereotype) {
            return XTUMLRTAnnotations._getAnnotationName((Stereotype)stereotype);
        }
        if (stereotype instanceof Annotation) {
            return XTUMLRTAnnotations._getAnnotationName((Annotation)stereotype);
        }
        if (stereotype != null) {
            return XTUMLRTAnnotations._getAnnotationName(stereotype);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stereotype).toString());
    }

    protected static Object getAnnotationProperty(EObject stereotype, String property) {
        if (stereotype instanceof Stereotype) {
            return XTUMLRTAnnotations._getAnnotationProperty((Stereotype)stereotype, property);
        }
        if (stereotype instanceof Annotation) {
            return XTUMLRTAnnotations._getAnnotationProperty((Annotation)stereotype, property);
        }
        if (stereotype != null) {
            return XTUMLRTAnnotations._getAnnotationProperty(stereotype, property);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stereotype, property).toString());
    }
}

