/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrusrt.xtumlrt.common.AbstractAction;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.statemach.ActionChain;
import org.eclipse.papyrusrt.xtumlrt.statemach.ChoicePoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.CompositeState;
import org.eclipse.papyrusrt.xtumlrt.statemach.DeepHistory;
import org.eclipse.papyrusrt.xtumlrt.statemach.EntryPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.ExitPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.Guard;
import org.eclipse.papyrusrt.xtumlrt.statemach.InitialPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.JunctionPoint;
import org.eclipse.papyrusrt.xtumlrt.statemach.Pseudostate;
import org.eclipse.papyrusrt.xtumlrt.statemach.State;
import org.eclipse.papyrusrt.xtumlrt.statemach.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.statemach.Transition;
import org.eclipse.papyrusrt.xtumlrt.statemach.Trigger;
import org.eclipse.papyrusrt.xtumlrt.statemach.Vertex;
import org.eclipse.papyrusrt.xtumlrt.statemachext.EntryAction;
import org.eclipse.papyrusrt.xtumlrt.statemachext.ExitAction;
import org.eclipse.papyrusrt.xtumlrt.statemachext.TransitionAction;
import org.eclipse.papyrusrt.xtumlrt.util.GeneralUtil;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class XTUMLRTStateMachineUtil {
    private static final XTUMLRTStateMachineUtil INSTANCE = new XTUMLRTStateMachineUtil();
    private final HashMap<ArrayList<?>, Integer> _createCache_getCachedDepthOf = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public static void addChoicePoint(CompositeState state, ChoicePoint point) {
        EList _choicePoints = state.getChoicePoints();
        _choicePoints.add((Object)point);
    }

    public static void addEntryPoint(State state, EntryPoint point) {
        EList _entryPoints = state.getEntryPoints();
        _entryPoints.add((Object)point);
    }

    public static void addExitPoint(State state, ExitPoint point) {
        EList _exitPoints = state.getExitPoints();
        _exitPoints.add((Object)point);
    }

    public static void addFirstAction(ActionChain chain, AbstractAction action) {
        EList _actions = chain.getActions();
        _actions.add(0, (Object)action);
    }

    public static void addJunctionPoint(CompositeState state, JunctionPoint point) {
        EList _junctionPoints = state.getJunctionPoints();
        _junctionPoints.add((Object)point);
    }

    public static void addLastAction(ActionChain chain, AbstractAction action) {
        EList _actions = chain.getActions();
        _actions.add((Object)action);
    }

    public static void addSubstate(CompositeState state, State s) {
        EList _substates = state.getSubstates();
        _substates.add((Object)s);
    }

    public static void addTransition(CompositeState state, Transition t) {
        EList _transitions = state.getTransitions();
        _transitions.add((Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCachedDepthOf(NamedElement element) {
        int _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new NamedElement[]{element});
        HashMap<ArrayList<?>, Integer> hashMap = this._createCache_getCachedDepthOf;
        synchronized (hashMap) {
            if (this._createCache_getCachedDepthOf.containsKey(_cacheKey)) {
                return this._createCache_getCachedDepthOf.get(_cacheKey);
            }
            int _xifexpression = 0;
            if (element == null) {
                _xifexpression = 0;
            } else {
                boolean _not;
                int _xifexpression_1 = 0;
                boolean _isStateMachineElement = XTUMLRTStateMachineUtil.isStateMachineElement(element);
                boolean bl = _not = !_isStateMachineElement;
                if (_not) {
                    _xifexpression_1 = -1;
                } else {
                    State _ownerState = XTUMLRTStateMachineUtil.getOwnerState(element);
                    int _cachedDepthOf = this.getCachedDepthOf((NamedElement)_ownerState);
                    _xifexpression_1 = _cachedDepthOf + 1;
                }
                _xifexpression = _xifexpression_1;
            }
            _result = _xifexpression;
            this._createCache_getCachedDepthOf.put(_cacheKey, _result);
        }
        this._init_getCachedDepthOf(_result, element);
        return _result;
    }

    private void _init_getCachedDepthOf(int it, NamedElement element) {
    }

    public static int getCachedDepth(NamedElement element) {
        return INSTANCE.getCachedDepthOf(element);
    }

    public Integer setCachedDepthOf(NamedElement element, int depth) {
        Integer _xblockexpression = null;
        ArrayList key = CollectionLiterals.newArrayList((Object[])new NamedElement[]{element});
        _xblockexpression = this._createCache_getCachedDepthOf.put(key, depth);
        return _xblockexpression;
    }

    public static Integer setCachedDepth(NamedElement element, int depth) {
        return INSTANCE.setCachedDepthOf(element, depth);
    }

    public static Iterable<Pseudostate> getConnectionPoints(State state) {
        ArrayList _xblockexpression = null;
        ArrayList connectionPoints = CollectionLiterals.newArrayList((Object[])new Pseudostate[0]);
        EList _entryPoints = state.getEntryPoints();
        connectionPoints.addAll(_entryPoints);
        EList _exitPoints = state.getExitPoints();
        connectionPoints.addAll(_exitPoints);
        _xblockexpression = connectionPoints;
        return _xblockexpression;
    }

    public static int getDepth(NamedElement element) {
        int _xifexpression = 0;
        if (Objects.equal((Object)element, null) || !XTUMLRTStateMachineUtil.isStateMachineElement(element)) {
            _xifexpression = 0;
        } else {
            State _ownerState = XTUMLRTStateMachineUtil.getOwnerState(element);
            int _depth = XTUMLRTStateMachineUtil.getDepth((NamedElement)_ownerState);
            _xifexpression = _depth + 1;
        }
        return _xifexpression;
    }

    protected static Iterable<Transition> _getDirectIncomingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State _ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)state);
        CompositeState owner = (CompositeState)_ownerState;
        if (owner != null) {
            EList _transitions = owner.getTransitions();
            for (Transition t : _transitions) {
                Vertex _targetVertex = t.getTargetVertex();
                boolean _equals = Objects.equal((Object)_targetVertex, (Object)state);
                if (!_equals) continue;
                transitions.add(t);
            }
        }
        if (state instanceof CompositeState) {
            EList _transitions_1 = ((CompositeState)state).getTransitions();
            for (Transition t_1 : _transitions_1) {
                Vertex _targetVertex_1 = t_1.getTargetVertex();
                boolean _equals_1 = Objects.equal((Object)_targetVertex_1, (Object)state);
                if (!_equals_1) continue;
                transitions.add(t_1);
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    protected static Iterable<Transition> _getDirectIncomingTransitions(Pseudostate pseudostate) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State owner = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)pseudostate);
        if (owner != null) {
            State _ownerState;
            CompositeState ownersOwner;
            if (owner instanceof CompositeState) {
                EList _transitions = ((CompositeState)owner).getTransitions();
                for (Transition t : _transitions) {
                    Vertex _targetVertex = t.getTargetVertex();
                    boolean _equals = Objects.equal((Object)_targetVertex, (Object)pseudostate);
                    if (!_equals) continue;
                    transitions.add(t);
                }
            }
            if ((XTUMLRTStateMachineUtil.isConnectionPoint((NamedElement)pseudostate) || pseudostate instanceof DeepHistory) && (ownersOwner = (CompositeState)(_ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)owner))) != null) {
                EList _transitions_1 = ownersOwner.getTransitions();
                for (Transition t_1 : _transitions_1) {
                    Vertex _targetVertex_1 = t_1.getTargetVertex();
                    boolean _equals_1 = Objects.equal((Object)_targetVertex_1, (Object)pseudostate);
                    if (!_equals_1) continue;
                    transitions.add(t_1);
                }
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    protected static Iterable<Transition> _getDirectOutgoingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State _ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)state);
        CompositeState owner = (CompositeState)_ownerState;
        if (owner != null) {
            EList _transitions = owner.getTransitions();
            for (Transition t : _transitions) {
                Vertex _sourceVertex = t.getSourceVertex();
                boolean _equals = Objects.equal((Object)_sourceVertex, (Object)state);
                if (!_equals) continue;
                transitions.add(t);
            }
        }
        if (state instanceof CompositeState) {
            EList _transitions_1 = ((CompositeState)state).getTransitions();
            for (Transition t_1 : _transitions_1) {
                Vertex _sourceVertex_1 = t_1.getSourceVertex();
                boolean _equals_1 = Objects.equal((Object)_sourceVertex_1, (Object)state);
                if (!_equals_1) continue;
                transitions.add(t_1);
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    protected static Iterable<Transition> _getDirectOutgoingTransitions(Pseudostate pseudostate) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        State owner = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)pseudostate);
        if (owner != null) {
            State _ownerState;
            CompositeState ownersOwner;
            boolean _isConnectionPoint;
            if (owner instanceof CompositeState) {
                EList _transitions = ((CompositeState)owner).getTransitions();
                for (Transition t : _transitions) {
                    Vertex _sourceVertex = t.getSourceVertex();
                    boolean _equals = Objects.equal((Object)_sourceVertex, (Object)pseudostate);
                    if (!_equals) continue;
                    transitions.add(t);
                }
            }
            if ((_isConnectionPoint = XTUMLRTStateMachineUtil.isConnectionPoint((NamedElement)pseudostate)) && (ownersOwner = (CompositeState)(_ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)owner))) != null) {
                EList _transitions_1 = ownersOwner.getTransitions();
                for (Transition t_1 : _transitions_1) {
                    Vertex _sourceVertex_1 = t_1.getSourceVertex();
                    boolean _equals_1 = Objects.equal((Object)_sourceVertex_1, (Object)pseudostate);
                    if (!_equals_1) continue;
                    transitions.add(t_1);
                }
            }
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Iterable<Transition> getIndirectIncomingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        Iterable<Pseudostate> _connectionPoints = XTUMLRTStateMachineUtil.getConnectionPoints(state);
        for (Pseudostate p : _connectionPoints) {
            Iterable<Transition> _directIncomingTransitions = XTUMLRTStateMachineUtil.getDirectIncomingTransitions((Vertex)p);
            Iterables.addAll((Collection)transitions, _directIncomingTransitions);
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Iterable<Transition> getIndirectOutgoingTransitions(State state) {
        ArrayList _xblockexpression = null;
        ArrayList transitions = CollectionLiterals.newArrayList((Object[])new Transition[0]);
        Iterable<Pseudostate> _connectionPoints = XTUMLRTStateMachineUtil.getConnectionPoints(state);
        for (Pseudostate p : _connectionPoints) {
            Iterable<Transition> _directOutgoingTransitions = XTUMLRTStateMachineUtil.getDirectOutgoingTransitions((Vertex)p);
            Iterables.addAll((Collection)transitions, _directOutgoingTransitions);
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    public static Iterable<Pseudostate> getInnerPseudostates(CompositeState state) {
        ArrayList _xblockexpression = null;
        ArrayList pseudostates = CollectionLiterals.newArrayList((Object[])new Pseudostate[0]);
        if (state != null) {
            InitialPoint _initial = state.getInitial();
            GeneralUtil.addIfNotNull(pseudostates, _initial);
            DeepHistory _deepHistory = state.getDeepHistory();
            GeneralUtil.addIfNotNull(pseudostates, _deepHistory);
            EList _choicePoints = state.getChoicePoints();
            pseudostates.addAll(_choicePoints);
            EList _junctionPoints = state.getJunctionPoints();
            pseudostates.addAll(_junctionPoints);
        }
        _xblockexpression = pseudostates;
        return _xblockexpression;
    }

    protected static State _getOwnerState(Trigger trigger) {
        State _xifexpression = null;
        if (trigger != null && XTUMLRTUtil.getOwner((CommonElement)trigger) != null && !Objects.equal((Object)XTUMLRTUtil.getOwner((CommonElement)XTUMLRTUtil.getOwner((CommonElement)trigger)), null) && XTUMLRTUtil.getOwner((CommonElement)XTUMLRTUtil.getOwner((CommonElement)trigger)) instanceof State) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)trigger);
            NamedElement _owner_1 = XTUMLRTUtil.getOwner((CommonElement)_owner);
            _xifexpression = (State)_owner_1;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(Guard guard) {
        State _xifexpression = null;
        if (guard != null && XTUMLRTUtil.getOwner((CommonElement)guard) != null && !Objects.equal((Object)XTUMLRTUtil.getOwner((CommonElement)XTUMLRTUtil.getOwner((CommonElement)guard)), null) && XTUMLRTUtil.getOwner((CommonElement)XTUMLRTUtil.getOwner((CommonElement)guard)) instanceof State) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)guard);
            NamedElement _owner_1 = XTUMLRTUtil.getOwner((CommonElement)_owner);
            _xifexpression = (State)_owner_1;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(EntryAction action) {
        State _xifexpression = null;
        if (action != null && XTUMLRTUtil.getOwner((CommonElement)action) != null && XTUMLRTUtil.getOwner((CommonElement)action) instanceof State) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)action);
            _xifexpression = (State)_owner;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(ExitAction action) {
        State _xifexpression = null;
        if (action != null && XTUMLRTUtil.getOwner((CommonElement)action) != null && XTUMLRTUtil.getOwner((CommonElement)action) instanceof State) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)action);
            _xifexpression = (State)_owner;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(TransitionAction action) {
        State _xifexpression = null;
        if (action != null && XTUMLRTUtil.getOwner((CommonElement)action) != null && XTUMLRTUtil.getOwner((CommonElement)action) instanceof ActionChain) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)action);
            _xifexpression = XTUMLRTStateMachineUtil.getOwnerState(_owner);
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(ActionChain actionChain) {
        State _xifexpression = null;
        if (actionChain != null && XTUMLRTUtil.getOwner((CommonElement)actionChain) != null && !Objects.equal((Object)XTUMLRTUtil.getOwner((CommonElement)XTUMLRTUtil.getOwner((CommonElement)actionChain)), null) && XTUMLRTUtil.getOwner((CommonElement)XTUMLRTUtil.getOwner((CommonElement)actionChain)) instanceof State) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)actionChain);
            NamedElement _owner_1 = XTUMLRTUtil.getOwner((CommonElement)_owner);
            _xifexpression = (State)_owner_1;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static State _getOwnerState(Vertex v) {
        State _xifexpression = null;
        if (v != null && XTUMLRTUtil.getOwner((CommonElement)v) != null && XTUMLRTUtil.getOwner((CommonElement)v) instanceof State) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)v);
            _xifexpression = (State)_owner;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    protected static CompositeState _getOwnerState(Transition t) {
        CompositeState _xifexpression = null;
        if (t != null && XTUMLRTUtil.getOwner((CommonElement)t) != null && XTUMLRTUtil.getOwner((CommonElement)t) instanceof CompositeState) {
            NamedElement _owner = XTUMLRTUtil.getOwner((CommonElement)t);
            _xifexpression = (CompositeState)_owner;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public static StateMachine getOwnerStateMachine(NamedElement element) {
        StateMachine _xblockexpression = null;
        StateMachine result = null;
        if (element != null) {
            NamedElement stateMachineElement = element;
            while (!(stateMachineElement instanceof StateMachine)) {
                NamedElement _owner;
                stateMachineElement = _owner = XTUMLRTUtil.getOwner((CommonElement)stateMachineElement);
            }
            if (stateMachineElement instanceof StateMachine) {
                result = (StateMachine)stateMachineElement;
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static Iterable<Vertex> getPossibleEndpoints(Transition transition) {
        State _ownerState;
        CompositeState state;
        ArrayList _xblockexpression = null;
        ArrayList vertices = CollectionLiterals.newArrayList((Object[])new Vertex[0]);
        if (transition != null && (state = (CompositeState)(_ownerState = XTUMLRTStateMachineUtil.getOwnerState((NamedElement)transition))) != null) {
            Functions.Function1<State, Iterable<Pseudostate>> _function;
            EList _substates = state.getSubstates();
            vertices.addAll(_substates);
            Iterable<Pseudostate> _pseudostates = XTUMLRTStateMachineUtil.getPseudostates(state);
            Iterables.addAll((Collection)vertices, _pseudostates);
            EList _substates_1 = state.getSubstates();
            Functions.Function1<State, Iterable<Pseudostate>> _final_function = _function = new Functions.Function1<State, Iterable<Pseudostate>>(){

                public Iterable<Pseudostate> apply(State it) {
                    return XTUMLRTStateMachineUtil.getConnectionPoints(it);
                }
            };
            List _map = ListExtensions.map((List)_substates_1, (Functions.Function1)_final_function);
            Iterables.addAll((Collection)vertices, (Iterable)_map);
        }
        _xblockexpression = vertices;
        return _xblockexpression;
    }

    public static Iterable<Pseudostate> getPseudostates(CompositeState state) {
        ArrayList _xblockexpression = null;
        ArrayList pseudostates = CollectionLiterals.newArrayList((Object[])new Pseudostate[0]);
        if (state != null) {
            Iterable<Pseudostate> _innerPseudostates = XTUMLRTStateMachineUtil.getInnerPseudostates(state);
            Iterables.addAll((Collection)pseudostates, _innerPseudostates);
            Iterable<Pseudostate> _connectionPoints = XTUMLRTStateMachineUtil.getConnectionPoints((State)state);
            Iterables.addAll((Collection)pseudostates, _connectionPoints);
        }
        _xblockexpression = pseudostates;
        return _xblockexpression;
    }

    public static State getSourceState(Transition transition) {
        State _xblockexpression = null;
        Vertex v = transition.getSourceVertex();
        State _xifexpression = null;
        if (v == null) {
            _xifexpression = null;
        } else {
            State _xifexpression_1 = null;
            _xifexpression_1 = v instanceof State ? (State)v : XTUMLRTStateMachineUtil.getOwnerState((NamedElement)v);
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static State getTargetState(Transition transition) {
        State _xblockexpression = null;
        Vertex v = transition.getTargetVertex();
        State _xifexpression = null;
        if (v == null) {
            _xifexpression = null;
        } else {
            State _xifexpression_1 = null;
            _xifexpression_1 = v instanceof State ? (State)v : XTUMLRTStateMachineUtil.getOwnerState((NamedElement)v);
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static boolean hasDeepHistory(CompositeState state) {
        return state != null && state.getDeepHistory() != null;
    }

    public static boolean hasInitial(CompositeState state) {
        return state != null && state.getInitial() != null;
    }

    public static boolean isConnectionPoint(NamedElement element) {
        return element instanceof EntryPoint || element instanceof ExitPoint;
    }

    public static boolean isStateMachineElement(NamedElement element) {
        return element instanceof Vertex || element instanceof Transition || element instanceof ActionChain || element instanceof AbstractAction || element instanceof Trigger || element instanceof Guard;
    }

    public static void removeChoicePoint(CompositeState state, ChoicePoint choicePoint) {
        EList _choicePoints = state.getChoicePoints();
        _choicePoints.remove((Object)choicePoint);
    }

    protected static void _removeConnectionPoint(State state, EntryPoint connectionPoint) {
        EList _entryPoints = state.getEntryPoints();
        _entryPoints.remove((Object)connectionPoint);
    }

    protected static void _removeConnectionPoint(State state, ExitPoint connectionPoint) {
        EList _exitPoints = state.getExitPoints();
        _exitPoints.remove((Object)connectionPoint);
    }

    public static void removeDeepHistory(CompositeState state) {
        state.setDeepHistory(null);
    }

    public static void removeEntryPoint(State state, EntryPoint point) {
        EList _entryPoints = state.getEntryPoints();
        _entryPoints.remove((Object)point);
    }

    public static void removeExitPoint(State state, ExitPoint point) {
        EList _exitPoints = state.getExitPoints();
        _exitPoints.remove((Object)point);
    }

    public static void removeGuard(Transition transition) {
        transition.setGuard(null);
    }

    public static void removeInitial(CompositeState state) {
        state.setInitial(null);
    }

    public static void removeJunctionPoint(CompositeState state, JunctionPoint junctionPoint) {
        EList _junctionPoints = state.getJunctionPoints();
        _junctionPoints.remove((Object)junctionPoint);
    }

    public static void removeTransition(CompositeState state, Transition transition) {
        EList _transitions = state.getTransitions();
        _transitions.remove((Object)transition);
    }

    public static void removeTriggers(Transition transition) {
        Trigger[] _clone;
        EList _triggers = transition.getTriggers();
        Trigger[] triggerArray = _clone = (Trigger[])((Trigger[])Conversions.unwrapArray((Object)_triggers, Trigger.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            EList _triggers_1 = transition.getTriggers();
            _triggers_1.remove((Object)trigger);
            ++n2;
        }
    }

    public static void removeSubstate(CompositeState state, State subState) {
        EList _substates = state.getSubstates();
        _substates.remove((Object)subState);
    }

    public static void removeState(StateMachine stateMachine, State subState) {
        CompositeState _top = stateMachine.getTop();
        XTUMLRTStateMachineUtil.removeSubstate(_top, subState);
    }

    protected static void _removePseudostate(CompositeState state, ChoicePoint pseudostate) {
        XTUMLRTStateMachineUtil.removeChoicePoint(state, pseudostate);
    }

    protected static void _removePseudostate(CompositeState state, DeepHistory pseudostate) {
        XTUMLRTStateMachineUtil.removeDeepHistory(state);
    }

    protected static void _removePseudostate(CompositeState state, EntryPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeEntryPoint((State)state, pseudostate);
    }

    protected static void _removePseudostate(CompositeState state, ExitPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeExitPoint((State)state, pseudostate);
    }

    protected static void _removePseudostate(CompositeState state, InitialPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeInitial(state);
    }

    protected static void _removePseudostate(CompositeState state, JunctionPoint pseudostate) {
        XTUMLRTStateMachineUtil.removeJunctionPoint(state, pseudostate);
    }

    public static Iterable<Transition> getDirectIncomingTransitions(Vertex pseudostate) {
        if (pseudostate instanceof Pseudostate) {
            return XTUMLRTStateMachineUtil._getDirectIncomingTransitions((Pseudostate)pseudostate);
        }
        if (pseudostate instanceof State) {
            return XTUMLRTStateMachineUtil._getDirectIncomingTransitions((State)pseudostate);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pseudostate).toString());
    }

    public static Iterable<Transition> getDirectOutgoingTransitions(Vertex pseudostate) {
        if (pseudostate instanceof Pseudostate) {
            return XTUMLRTStateMachineUtil._getDirectOutgoingTransitions((Pseudostate)pseudostate);
        }
        if (pseudostate instanceof State) {
            return XTUMLRTStateMachineUtil._getDirectOutgoingTransitions((State)pseudostate);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pseudostate).toString());
    }

    public static State getOwnerState(NamedElement action) {
        if (action instanceof EntryAction) {
            return XTUMLRTStateMachineUtil._getOwnerState((EntryAction)action);
        }
        if (action instanceof ExitAction) {
            return XTUMLRTStateMachineUtil._getOwnerState((ExitAction)action);
        }
        if (action instanceof TransitionAction) {
            return XTUMLRTStateMachineUtil._getOwnerState((TransitionAction)action);
        }
        if (action instanceof Transition) {
            return XTUMLRTStateMachineUtil._getOwnerState((Transition)action);
        }
        if (action instanceof ActionChain) {
            return XTUMLRTStateMachineUtil._getOwnerState((ActionChain)action);
        }
        if (action instanceof Guard) {
            return XTUMLRTStateMachineUtil._getOwnerState((Guard)action);
        }
        if (action instanceof Trigger) {
            return XTUMLRTStateMachineUtil._getOwnerState((Trigger)action);
        }
        if (action instanceof Vertex) {
            return XTUMLRTStateMachineUtil._getOwnerState((Vertex)action);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(action).toString());
    }

    public static void removeConnectionPoint(State state, Pseudostate connectionPoint) {
        if (connectionPoint instanceof EntryPoint) {
            XTUMLRTStateMachineUtil._removeConnectionPoint(state, (EntryPoint)connectionPoint);
            return;
        }
        if (connectionPoint instanceof ExitPoint) {
            XTUMLRTStateMachineUtil._removeConnectionPoint(state, (ExitPoint)connectionPoint);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(state, connectionPoint).toString());
    }

    public static void removePseudostate(CompositeState state, Pseudostate pseudostate) {
        if (pseudostate instanceof ChoicePoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (ChoicePoint)pseudostate);
            return;
        }
        if (pseudostate instanceof DeepHistory) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (DeepHistory)pseudostate);
            return;
        }
        if (pseudostate instanceof EntryPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (EntryPoint)pseudostate);
            return;
        }
        if (pseudostate instanceof ExitPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (ExitPoint)pseudostate);
            return;
        }
        if (pseudostate instanceof InitialPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (InitialPoint)pseudostate);
            return;
        }
        if (pseudostate instanceof JunctionPoint) {
            XTUMLRTStateMachineUtil._removePseudostate(state, (JunctionPoint)pseudostate);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(state, pseudostate).toString());
    }
}

