/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class RTRegionEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ConfigureElementCommand command = new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
                EObject elementToConfigure = request.getElementToConfigure();
                if (!(elementToConfigure instanceof Region)) {
                    return CommandResult.newErrorCommandResult((String)"Element to configure is not a region");
                }
                Region region = (Region)elementToConfigure;
                try {
                    Pseudostate pseudoState = RTRegionEditHelperAdvice.this.createInitialState(region, monitor, info, null);
                    State initialState = RTRegionEditHelperAdvice.this.createFirstSimpleState(region, monitor, info, "State1");
                    RTRegionEditHelperAdvice.this.createInitialTransition(region, (Vertex)pseudoState, (Vertex)initialState, monitor, info, "Initial");
                    return CommandResult.newOKCommandResult((Object)region);
                }
                catch (ExecutionException e) {
                    return CommandResult.newErrorCommandResult((Throwable)e);
                }
            }
        };
        ICommand superCommand = super.getBeforeConfigureCommand(request);
        if (superCommand != null) {
            return command.compose((IUndoableOperation)superCommand).reduce();
        }
        return command.reduce();
    }

    protected Pseudostate createInitialState(Region region, IProgressMonitor monitor, IAdaptable info, String pseudoStateName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)region, (IElementType)UMLRTElementTypesEnumerator.RT_PSEUDO_STATE_INITIAL);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)region);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + region);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof Pseudostate)) {
                        throw new ExecutionException("Element creation problem for PseudoState .");
                    }
                    ((Pseudostate)newElement).setName(pseudoStateName);
                    return (Pseudostate)newElement;
                }
                throw new ExecutionException("Impossible to create the pseudo state");
            }
            throw new ExecutionException("Command to create the pseudo state is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the Pseudostate");
    }

    protected State createFirstSimpleState(Region region, IProgressMonitor monitor, IAdaptable info, String firstStateName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)region, (IElementType)UMLRTElementTypesEnumerator.RT_STATE);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)region);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + region);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof State)) {
                        throw new ExecutionException("Element creation problem for State .");
                    }
                    ((State)newElement).setName(firstStateName);
                    return (State)newElement;
                }
                throw new ExecutionException("Impossible to create the first simple state");
            }
            throw new ExecutionException("Command to create the first simple state is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the first simple state");
    }

    protected Transition createInitialTransition(Region region, Vertex source, Vertex target, IProgressMonitor monitor, IAdaptable info, String firstTransitionName) throws ExecutionException {
        EObject newElement = null;
        CreateElementRequest createElementRequest = new CreateElementRequest((EObject)region, (IElementType)UMLElementTypes.TRANSITION);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)region);
        if (provider == null) {
            throw new ExecutionException("Impossible to get the provider from " + region);
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        if (createGMFCommand != null) {
            if (createGMFCommand.canExecute()) {
                IStatus status = createGMFCommand.execute(monitor, info);
                if (status.isOK()) {
                    newElement = GMFCommandUtils.getCommandEObjectResult((ICommand)createGMFCommand);
                    if (!(newElement instanceof Transition)) {
                        throw new ExecutionException("Element creation problem for Transition .");
                    }
                    ((Transition)newElement).setName(firstTransitionName);
                    if (source != null) {
                        ((Transition)newElement).setSource(source);
                    }
                    if (target != null) {
                        ((Transition)newElement).setTarget(target);
                    }
                    return (Transition)newElement;
                }
                throw new ExecutionException("Impossible to create the initial Transition");
            }
            throw new ExecutionException("Command to create initial Transition is not executable");
        }
        throw new ExecutionException("Impossible to find a command to create the initial Transition");
    }
}

