/*******************************************************************************
 * Copyright (c) 2016 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Stefan Dirix - initial API and implementation
 *******************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.decorator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.DecoratorAdapterFactory;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolChange;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.ProtocolMessageChange;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTDiff;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.provider.UMLRTCompareItemProviderAdapterFactory;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.util.UMLRTCompareSwitch;

public class UMLRTDiffItemProviderDecoratorAdapterFactory extends DecoratorAdapterFactory {

	public UMLRTDiffItemProviderDecoratorAdapterFactory() {
		super(new UMLRTCompareItemProviderAdapterFactory());
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 */
	private final UMLRTCompareSwitch<IItemProviderDecorator> modelSwitch = new UMLRTCompareSwitch<IItemProviderDecorator>() {
		@Override
		public IItemProviderDecorator caseProtocolChange(ProtocolChange object) {
			return createProtocolChangeItemProviderDecorator();
		}

		@Override
		public IItemProviderDecorator caseProtocolMessageChange(ProtocolMessageChange object) {
			 return createProtocolMessageChangeItemProviderDecorator();
		};

		@Override
		public IItemProviderDecorator caseUMLRTDiff(UMLRTDiff object) {
			return createUMLRTDiffItemProviderDecorator();
		};
	};

	@Override
	protected IItemProviderDecorator createItemProviderDecorator(Object target, Object Type) {
		return modelSwitch.doSwitch((EObject) target);
	}

	protected IItemProviderDecorator createProtocolChangeItemProviderDecorator() {
		return new ProtocolChangeItemProviderDecorator(this);
	}

	protected IItemProviderDecorator createProtocolMessageChangeItemProviderDecorator() {
		return new ProtocolMessageChangeItemProviderDecorator(this);
	}

	protected IItemProviderDecorator createUMLRTDiffItemProviderDecorator() {
		return new UMLRTDiffItemProviderDecorator(this);
	}
}
