/*****************************************************************************
 * Copyright (c) 2016 EclipseSource Services GmbH
 * *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Stefan Dirix (EclipseSource) - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.compare.ui.internal.differenceGroup;

import java.util.Iterator;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.tree.TreeNode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableList.Builder;

/**
 * @author Stefan Dirix
 */
public abstract class AbstractFilteringGroupExtender implements IDifferenceGroupExtender {

	/**
	 * @see org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender#addChildren(org.eclipse.emf.edit.tree.TreeNode)
	 *
	 * @param treeNode
	 */
	@Override
	public void addChildren(TreeNode treeNode) {
		final AdapterFactory adapterFactory = getAdapterFactory();
		final Builder<TreeNode> collectedGrandChildren = ImmutableList.builder();
		final Iterator<TreeNode> iterator = treeNode.getChildren().iterator();
		while (iterator.hasNext()) {
			final TreeNode childTreeNode = iterator.next();
			if (shouldFilter(childTreeNode, adapterFactory)) {
				collectedGrandChildren.addAll(childTreeNode.getChildren());
				iterator.remove();
			}
		}
		treeNode.getChildren().addAll(collectedGrandChildren.build());
		if (IDisposable.class.isInstance(adapterFactory)) {
			IDisposable.class.cast(adapterFactory).dispose();
		}
	}

	/**
	 * Indicates whether the given {@code treeNode} shall be filtered.
	 * 
	 * @param treeNode
	 *            the {@link TreeNode} for which it is to be determined if it shall be filtered.
	 * @param adapterFactory
	 *            the {@link AdapterFactory} which is returned by {@link #getAdapterFactory()}.
	 * @return
	 * 		{@code true} if the given {@code treeNode} shall be filtered, {@code false} otherwise.
	 */
	protected abstract boolean shouldFilter(TreeNode treeNode, AdapterFactory adapterFactory);

	/**
	 * The {@link AdapterFactory} which is used in the {@link #shouldFilter(TreeNode, AdapterFactory)} method.
	 * 
	 * The default implementation returns the registry used by EMFCompare.
	 * 
	 * @return the {@link AdapterFactory} to use.
	 */
	protected AdapterFactory getAdapterFactory() {
		ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(EMFCompareRCPPlugin.getDefault()
				.createFilteredAdapterFactoryRegistry());
		return adapterFactory;
	}

}
