/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.papyrusrt.umlrt.tooling.compare.internal.UMLRTExtensionFactoryRegistry;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTDiff;

public class UMLRTPostProcessor
implements IPostProcessor {
    private Map<Class<? extends Diff>, IChangeFactory> umlRtExtensionFactoriesMap;

    public void postComparison(Comparison comparison, Monitor monitor) {
        this.applyUMLRTDiffExtensions(comparison);
        this.rewriteConflictsInvolvingUMLRTDiffs(comparison);
    }

    /*
     * Unable to fully structure code
     */
    private void rewriteConflictsInvolvingUMLRTDiffs(Comparison comparison) {
        needUpdate = this.getConflictsInvolvingUMLRTDiffs(comparison);
        if (needUpdate.size() >= 2) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            currentConflict = needUpdate.get(0);
            updated = new ArrayList<Conflict>();
            updated.add(currentConflict);
            change1 = this.getUMLRTDiff(currentConflict);
            if (change1 != null && (change2 = this.getConflictingUMLRTDiff(currentConflict, change1)) != null) {
                updated.add(change2.getConflict());
                if (change1.getConflict() != null && change2.getConflict() != null && !change1.getConflict().equals(change2.getConflict())) {
                    this.joinConflicts(change1, change2, comparison);
                }
            }
            needUpdate.removeAll(updated);
lbl16:
            // 2 sources

            ** while (!needUpdate.isEmpty())
        }
lbl17:
        // 1 sources

    }

    private List<Conflict> getConflictsInvolvingUMLRTDiffs(Comparison comparison) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)comparison.getConflicts(), UMLRTPostProcessor.conflictInvolvesUMLRTDiff()));
    }

    private static Predicate<Conflict> conflictInvolvesUMLRTDiff() {
        return new Predicate<Conflict>(){

            public boolean apply(Conflict input) {
                return input != null && Iterables.any((Iterable)input.getDifferences(), (Predicate)Predicates.or((Predicate)Predicates.instanceOf(UMLRTDiff.class), (Predicate)UMLRTPostProcessor.diffRefinesDiffType(UMLRTDiff.class)));
            }
        };
    }

    private static Predicate<Diff> diffRefinesDiffType(final Class<?> clazz) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input != null && Iterables.any((Iterable)input.getRefines(), (Predicate)Predicates.instanceOf((Class)clazz));
            }
        };
    }

    private void joinConflicts(UMLRTDiff change1, UMLRTDiff change2, Comparison comparison) {
        Conflict change2Conflict = change2.getConflict();
        change1.getConflict().getDifferences().addAll((Collection)change2Conflict.getDifferences());
        comparison.getConflicts().remove((Object)change2Conflict);
    }

    private UMLRTDiff getUMLRTDiff(Conflict conflict) {
        return (UMLRTDiff)Iterables.find((Iterable)conflict.getDifferences(), (Predicate)Predicates.instanceOf(UMLRTDiff.class), null);
    }

    private UMLRTDiff getConflictingUMLRTDiff(Conflict conflict, UMLRTDiff change) {
        for (Diff conflictingDiff : conflict.getDifferences()) {
            if (conflictingDiff == change || conflictingDiff.getSource() == change.getSource()) continue;
            if (conflictingDiff instanceof UMLRTDiff) {
                return (UMLRTDiff)conflictingDiff;
            }
            UMLRTDiff result = (UMLRTDiff)Iterables.find((Iterable)conflictingDiff.getRefines(), (Predicate)Predicates.instanceOf(UMLRTDiff.class), null);
            if (result == change) continue;
            return result;
        }
        return null;
    }

    private void applyUMLRTDiffExtensions(Comparison comparison) {
        this.umlRtExtensionFactoriesMap = this.createExtensionFactories();
        this.createUMLRTDiffExtensions(comparison);
        this.fillRequiredDifferences(comparison);
    }

    private Map<Class<? extends Diff>, IChangeFactory> createExtensionFactories() {
        return UMLRTExtensionFactoryRegistry.createExtensionFactories();
    }

    private void createUMLRTDiffExtensions(Comparison comparison) {
        for (Diff diff : comparison.getDifferences()) {
            this.createUMLRTDiffExtension(diff);
        }
    }

    private void createUMLRTDiffExtension(Diff element) {
        for (IChangeFactory factory : this.umlRtExtensionFactoriesMap.values()) {
            Match match;
            Diff extension;
            if (!factory.handles(element) || (extension = factory.create(element)).getRefinedBy().isEmpty() || (match = factory.getParentMatch(element)) == null) continue;
            match.getDifferences().add((Object)extension);
        }
    }

    private void fillRequiredDifferences(Comparison comparison) {
        for (Diff umlDiff : comparison.getDifferences()) {
            Class classDiffElement;
            IChangeFactory diffFactory;
            if (!(umlDiff instanceof UMLDiff) || (diffFactory = this.umlRtExtensionFactoriesMap.get(classDiffElement = umlDiff.eClass().getInstanceClass())) == null) continue;
            diffFactory.fillRequiredDifferences(comparison, umlDiff);
        }
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }
}

