/*****************************************************************************
 * Copyright (c) 2009-2011 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Yann Tanguy (CEA LIST) yann.tanguy@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.BehaviorFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.LineDecorator;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.PortFigure;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTBehaviorPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTLineDecoratorLocator;
import org.eclipse.swt.graphics.Color;


/**
 * Workaround for Bug 504059 - [Tooling] The orientation of the behavior adornment is not updated when moving port to another border
 * Fixed in nightly neon. Workaround, since PapyrusRT is currently linked against neon-SR1. To be removed, once linked against Neon-SR2
 * Modification is in restoreBehaviorFigure - rather complete copy is required, since myBehavior is private in PortFigure
 */
@Deprecated
public class PortFigureCopy extends PortFigure {

	private BehaviorFigure myBehavior = null;

	private LineDecorator myLineDecor = null;

	@Override
	public boolean isBehaviored() {
		return myBehavior != null && myLineDecor != null
				&& getBorderItemContainer().getChildren().contains(myBehavior) &&
				getBorderItemContainer().getChildren().contains(myBehavior);
	}

	@Override
	public BehaviorFigure getBehavior() {
		return myBehavior;
	}

	@Override
	public void restoreBehaviorFigure() {
		if (myBehavior == null) {
			myBehavior = createBehavior();
		}
		if (myLineDecor == null) {
			myLineDecor = createLineDecorator();
		}
		if (!getBorderItemContainer().getChildren().contains(myBehavior)) {
			getBorderItemContainer().add(myBehavior, new RTBehaviorPositionLocator(this));
		}
		if (!getBorderItemContainer().getChildren().contains(myLineDecor)) {
			getBorderItemContainer().add(myLineDecor, new RTLineDecoratorLocator(this));
		}
	}

	@Override
	protected BehaviorFigure createBehavior() {
		return super.createBehavior();
	}

	private LineDecorator createLineDecorator() {
		LineDecorator line = new LineDecorator();
		line.setForegroundColor(getForegroundColor());
		line.setBackgroundColor(getBackgroundColor());
		line.setLineWidth(getLineWidth());
		line.setLineStyle(getLineStyle());
		return line;
	}

	@Override
	public void removeBehavior() {
		if (myBehavior != null) {
			if (getBorderItemContainer().getChildren().contains(myBehavior)) {
				getBorderItemContainer().remove(myBehavior);
			}
		}
		if (myLineDecor != null) {
			if (getBorderItemContainer().getChildren().contains(myLineDecor)) {
				getBorderItemContainer().remove(myLineDecor);
			}
		}
	}

	private IFigure getBorderItemContainer() {
		IFigure borderedFigure = this;
		while (false == borderedFigure instanceof BorderedNodeFigure && borderedFigure != null) {
			borderedFigure = borderedFigure.getParent();
		}
		return ((BorderedNodeFigure) borderedFigure).getBorderItemContainer();
	}

	@Override
	public void setShadowColor(String shadowColor) {
		super.setShadowColor(shadowColor);
		if (myBehavior != null) {
			myBehavior.setShadowColor(shadowColor);
		}
	}

	@Override
	public void setShadowWidth(int shadowWidth) {
		super.setShadowWidth(shadowWidth);
		if (myBehavior != null) {
			myBehavior.setShadowWidth(shadowWidth);
		}
	}

	@Override
	public void setShadow(boolean shadow) {
		super.setShadow(shadow);
		if (myBehavior != null) {
			myBehavior.setShadow(shadow);
		}
	}

	@Override
	public void setLineStyle(int s) {
		super.setLineStyle(s);
		if (myBehavior != null) {
			myBehavior.setLineStyle(s);
		}
		if (myLineDecor != null) {
			myLineDecor.setLineStyle(s);
		}
	}

	@Override
	public void setLineWidth(int w) {
		super.setLineWidth(w);
		if (myBehavior != null) {
			myBehavior.setLineWidth(w);
		}
		if (myLineDecor != null) {
			myLineDecor.setLineWidth(w);
		}
	}

	@Override
	public void setForegroundColor(Color fg) {
		super.setForegroundColor(fg);
		if (myBehavior != null) {
			myBehavior.setForegroundColor(fg);
			myBehavior.setBackgroundColor(fg);
		}
		if (myLineDecor != null) {
			myLineDecor.setForegroundColor(fg);
		}
	}
}
