/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.canonical;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.custom.canonical.PropertyPartCompartmentSemanticChildrenStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * Semantic children strategy for parts, defining specific restrictions on
 * the inclusion of ports on parts.
 */
public class RTPartSemanticChildrenStrategy extends PropertyPartCompartmentSemanticChildrenStrategy {

	public RTPartSemanticChildrenStrategy() {
		super();
	}

	/**
	 * Excludes non-service ports from the canonical children. Note that
	 * non-service ports are nonetheless monitored as dependencies because their
	 * disposition can be changed at any time.
	 */
	@Override
	public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
		List<? extends EObject> result = super.getCanonicalSemanticChildren(semanticFromEditPart, viewFromEditPart);

		if (result != null) {
			// Remove non-service ports
			for (Iterator<? extends EObject> iter = result.iterator(); iter.hasNext();) {
				EObject next = iter.next();
				if (next instanceof Port) {
					Port port = (Port) next;

					if (!RTPortUtils.isService(port)) {
						// Don't present it in the diagram
						iter.remove();
					}

					// But, in any case, listen for changes of service-ness
					DiagramEventBroker.getInstance(TransactionUtil.getEditingDomain(viewFromEditPart))
							.addNotificationListener(port, UMLPackage.Literals.PORT__IS_SERVICE,
									new CanonicalRefreshListener<>(viewFromEditPart, port));
				}
			}
		}

		return result;
	}

}
