/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.editpolicies;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.IndirectPropertyLabelEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RTPropertyLabelHelper;

/**
 * Custom mask-label edit policy for UML-RT diagrams that delegates
 * display configuration to the RT-specific label helper.
 * 
 * @see RTPropertyLabelHelper
 */
public class RTMaskLabelEditPolicy extends IndirectPropertyLabelEditPolicy {

	@Override
	public void refreshDisplay() {
		// calls the helper for this edit part
		RTPropertyLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart) getHost());
	}

}
