/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.figures.PortFigure;
import org.eclipse.papyrus.uml.diagram.composite.custom.locators.LineDecoratorLocator;

/**
 * Workaround for Bug 504059 - [Tooling] The orientation of the behavior adornment is not updated when moving port to another border
 * Fixed in nightly neon. Workaround, since PapyrusRT is currently linked against neon-SR1. To be removed, once linked against Neon-SR2
 */
@Deprecated
public class RTLineDecoratorLocator extends LineDecoratorLocator {

	/**
	 * Constructor.
	 *
	 * @param port
	 */
	public RTLineDecoratorLocator(PortFigure port) {
		super(port);
	}

	@Override
	protected int getPortSide() {
		Rectangle parent = getParentBounds();
		Rectangle port = myPort.getBounds();

		int yPortLocation = port.y + port.height / 2;
		int xPortLocation = port.x + port.width / 2;

		int side = 0;
		;
		if (nearByOne(yPortLocation, parent.y)) {
			side = side | PositionConstants.NORTH;
		}
		if (nearByOne(yPortLocation, parent.y + parent.height)) {
			side = side | PositionConstants.SOUTH;
		}
		if (nearByOne(xPortLocation, parent.x)) {
			side = side | PositionConstants.WEST;
		}
		if (nearByOne(xPortLocation, parent.x + parent.width)) {
			side = side | PositionConstants.EAST;
		}

		// side == 0 the port located not on the board of the parent
		return side == 0 ? PositionConstants.SOUTH : side;
	}

	/**
	 * @param pos1
	 *            first number
	 * @param pos2
	 *            second number
	 * @return true, if absolute of the difference between two integers is smaller than one
	 */
	public static boolean nearByOne(int pos1, int pos2) {
		return Math.abs(pos1 - pos2) <= 1;
	}

	private Rectangle getParentBounds() {
		IFigure parent = myPort.getParent();
		while (false == parent instanceof SelectableBorderedNodeFigure && parent != null) {
			parent = parent.getParent();
		}
		return ((SelectableBorderedNodeFigure) parent).getMainFigure().getBounds();
	}
}
