/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.drop;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.CustomizableDropEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.SystemElementsUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.RTClassCompositeCompartmentEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.RTClassCompositeEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.drop.FilteredDropEditPolicy;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class RTCapsuleStructureDiagramDragDropEditPolicy
extends CustomizableDropEditPolicy {
    private static final String ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_DND_CLASSIFIER_TO_STRUCTURE_COMP_AS_PROPERTY_DROP = "org.eclipse.papyrus.uml.diagram.dnd.ClassifierToStructureCompAsPropertyDrop";
    private static final String PREFERRED_STRATEGY_PREFIX = "org.eclipse.papyrusrt.";

    public RTCapsuleStructureDiagramDragDropEditPolicy(EditPolicy defaultDropEditPolicy, EditPolicy defaultCreationEditPolicy) {
        super((EditPolicy)RTCapsuleStructureDiagramDragDropEditPolicy.filter(defaultDropEditPolicy), defaultCreationEditPolicy);
    }

    protected Map<DropStrategy, List<Command>> findExtendedStrategies(Request request) {
        DropObjectsRequest drop;
        Stream<EObject> dropped;
        Map result = super.findExtendedStrategies(request);
        if (this.hasPreferredDropStrategies(result.keySet())) {
            result = this.removeStrategies(result, ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_DND_CLASSIFIER_TO_STRUCTURE_COMP_AS_PROPERTY_DROP, "default");
        } else if (request instanceof DropObjectsRequest && (dropped = (drop = (DropObjectsRequest)request).getObjects().stream().filter(EObject.class::isInstance).map(EObject.class::cast)).anyMatch(o -> RTCapsuleStructureDiagramDragDropEditPolicy.isInvalidTypeOnCapsule(o, this.getHost()))) {
            result = this.removeStrategies(result, ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_DND_CLASSIFIER_TO_STRUCTURE_COMP_AS_PROPERTY_DROP);
        }
        return result;
    }

    private <T> Map<DropStrategy, T> removeStrategies(Map<DropStrategy, T> strategies, String ... identifiers) {
        HashSet<String> forbidden = new HashSet<String>(Arrays.asList(identifiers));
        HashMap<DropStrategy, T> result = new HashMap<DropStrategy, T>(strategies);
        result.keySet().removeIf(k -> forbidden.contains(k.getID()));
        return result;
    }

    protected boolean hasPreferredDropStrategies(Collection<? extends DropStrategy> strategies) {
        return strategies.stream().map(DropStrategy::getID).anyMatch(id -> id.startsWith(PREFERRED_STRATEGY_PREFIX));
    }

    private static FilteredDropEditPolicy filter(EditPolicy delegate) {
        BiPredicate<EObject, EditPart> baseFilter = FilteredDropEditPolicy::hasView;
        BiPredicate<EObject, EditPart> invalidPortOnPart = RTCapsuleStructureDiagramDragDropEditPolicy::isInvalidPortOnCapsulePart;
        BiPredicate<EObject, EditPart> invalidTypeOnCapsule = RTCapsuleStructureDiagramDragDropEditPolicy::isInvalidTypeOnCapsule;
        BiPredicate<EObject, EditPart> invalidPortOnCapsule = RTCapsuleStructureDiagramDragDropEditPolicy::isInvalidPortOnCapsule;
        return new FilteredDropEditPolicy(delegate, baseFilter.or(invalidPortOnPart).or(invalidTypeOnCapsule).or(invalidPortOnCapsule));
    }

    private static boolean isInvalidPortOnCapsulePart(EObject element, EditPart editPart) {
        boolean result = false;
        if (element instanceof Port) {
            Property property;
            EObject dropOn;
            Port port = (Port)element;
            RTPortKindEnum kind = RTPortUtils.getKind((Port)port);
            if (port.getClass_() != null && kind != null && (dropOn = (EObject)PlatformHelper.getAdapter((Object)editPart, EObject.class)) instanceof Property && CapsulePartUtils.isCapsulePart((Property)(property = (Property)dropOn)) && property.getType() instanceof Class) {
                Class capsule = (Class)property.getType();
                result = !kind.isExternal() || !capsule.conformsTo((Type)port.getClass_());
            }
        }
        return result;
    }

    private static boolean isCapsule(EObject object) {
        return object instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)object));
    }

    private static boolean isInvalidTypeOnCapsule(EObject element, EditPart editPart) {
        boolean result = false;
        if (element instanceof Type && editPart instanceof IGraphicalEditPart && RTCapsuleStructureDiagramDragDropEditPolicy.isCapsule(((IGraphicalEditPart)editPart).resolveSemanticElement())) {
            result = !RTCapsuleStructureDiagramDragDropEditPolicy.isCapsule(element) && ProtocolUtils.isProtocol((EObject)element) == false;
        }
        return result;
    }

    private static boolean isInvalidPortOnCapsule(EObject element, EditPart editPart) {
        boolean result = false;
        if (element instanceof Collaboration) {
            Collaboration collaboration = (Collaboration)element;
            if (editPart instanceof RTClassCompositeEditPart) {
                if (SystemElementsUtils.isSystemProtocol((Collaboration)collaboration)) {
                    result = true;
                } else if (SystemElementsUtils.isBaseProtocol((Collaboration)collaboration)) {
                    result = true;
                }
            } else if (editPart instanceof RTClassCompositeCompartmentEditPart && SystemElementsUtils.isBaseProtocol((Collaboration)collaboration)) {
                result = true;
            }
        }
        return result;
    }
}

