/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.NodeSnapHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.uml2.uml.Element;

public class BorderItemHelper<E extends Element> {
    private final Class<? extends E> semanticType;
    private final Supplier<? extends IGraphicalEditPart> hostSupplier;
    private final Supplier<? extends PortPositionLocator> positionLocatorSupplier;
    private E element;

    public BorderItemHelper(Class<? extends E> semanticType, Supplier<? extends IGraphicalEditPart> hostSupplier, Supplier<? extends PortPositionLocator> positionLocatorSupplier) {
        this.semanticType = semanticType;
        this.hostSupplier = hostSupplier;
        this.positionLocatorSupplier = positionLocatorSupplier;
    }

    public E getElement() {
        return this.element;
    }

    public ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Function<? super E, Optional<Dimension>> sizeFunction, BiFunction<? super CreateViewRequest, ? super CreateViewRequest.ViewDescriptor, ? extends ICommand> delegate) {
        IAdaptable adaptable = descriptor.getElementAdapter();
        this.element = adaptable != null ? (Element)TypeUtils.as((Object)adaptable.getAdapter(EObject.class), this.semanticType) : null;
        return Optional.ofNullable(this.element).flatMap(sizeFunction::apply).map(d -> this.basicGetSetBoundsCommand(request, descriptor, (Dimension)d)).orElseGet(() -> (ICommand)delegate.apply(request, descriptor));
    }

    public ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Dimension size) {
        return this.basicGetSetBoundsCommand(request, descriptor, size);
    }

    private ICommand basicGetSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor, Dimension size) {
        SetBoundsCommand setBoundsCommand = null;
        IGraphicalEditPart host = this.hostSupplier.get();
        IFigure hostFigure = host.getFigure();
        TransactionalEditingDomain editingDomain = host.getEditingDomain();
        Point parentLoc = hostFigure.getBounds().getLocation().getCopy();
        Map params = request.getExtendedData();
        Point realLocation = (Point)params.get("initialMouseLocationForCreation");
        Point realWantedLocation = realLocation != null ? realLocation.getCopy() : request.getLocation().getCopy();
        Point requestedLocation = realWantedLocation.getCopy();
        hostFigure.translateToRelative((Translatable)requestedLocation);
        PortPositionLocator locator = this.positionLocatorSupplier.get();
        if (locator == null) {
            return null;
        }
        Rectangle preferredBounds = locator.getPreferredLocation(new Rectangle(requestedLocation, size));
        Rectangle retainedBounds = preferredBounds.getCopy();
        Rectangle parentBounds = hostFigure.getBounds().getCopy();
        locator.setConstraint(preferredBounds.getCopy().translate(parentBounds.getLocation().getNegated()));
        int currentSide = locator.getCurrentSideOfParent();
        if (request.isSnapToEnabled() && currentSide != 17 && currentSide != 9 && currentSide != 20 && currentSide != 12) {
            Point wantedPoint = preferredBounds.getLocation();
            hostFigure.translateToAbsolute((Translatable)wantedPoint);
            Rectangle portBounds = new Rectangle(wantedPoint, size);
            NodeSnapHelper helper = new NodeSnapHelper((SnapToHelper)host.getAdapter(SnapToHelper.class), portBounds, false, false, true);
            ChangeBoundsRequest tmpRequest = new ChangeBoundsRequest((Object)"move");
            tmpRequest.setEditParts(Collections.emptyList());
            tmpRequest.setSnapToEnabled(true);
            tmpRequest.setLocation(portBounds.getLocation());
            helper.snapPoint(tmpRequest);
            preferredBounds.translate(tmpRequest.getMoveDelta());
            switch (currentSide) {
                case 1: 
                case 4: {
                    preferredBounds.y = retainedBounds.y;
                    break;
                }
                case 8: 
                case 16: {
                    preferredBounds.x = retainedBounds.x;
                    break;
                }
            }
        }
        Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
        setBoundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)descriptor, creationBounds);
        return setBoundsCommand;
    }

    public PortPositionLocator getPositionLocator(Function<? super E, OptionalDouble> scaleFactorFunction, Supplier<? extends PortPositionLocator> delegate) {
        OptionalDouble scaleFactor = Optional.ofNullable(this.element).map(scaleFactorFunction::apply).orElse(OptionalDouble.empty());
        return scaleFactor.isPresent() ? new RTPortPositionLocator((Element)this.element, this.hostSupplier.get().getFigure(), 0, scaleFactor.getAsDouble()) : delegate.get();
    }
}

