/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;

public class UMLRTCapsuleStructureDiagramUtils {
    public static boolean isCapsuleStructureDiagram(Diagram diagram) {
        EObject businessElement;
        if (diagram == null) {
            return false;
        }
        return "CompositeStructure".equals(diagram.getType()) && (businessElement = diagram.getElement()) instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)businessElement));
    }

    public static String getDisplayedCapsuleStructureDiagramName(Diagram diagram) {
        if (diagram.getName() != null && !"".equals(diagram.getName())) {
            return diagram.getName();
        }
        EObject businessElement = diagram.getElement();
        if (businessElement instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)businessElement))) {
            return ((Classifier)businessElement).getName();
        }
        return diagram.getName();
    }

    public static Diagram getCapsuleStructureDiagram(Class capsule) {
        return UMLRTCapsuleStructureDiagramUtils.getDiagram((EObject)capsule, UMLRTCapsuleStructureDiagramUtils::isCapsuleStructureDiagram);
    }

    static Diagram getDiagram(EObject context, Predicate<? super Diagram> filter) {
        if (filter == null) {
            filter = __ -> true;
        }
        return EMFHelper.getUsages((EObject)context).stream().filter(s -> s.getEObject() instanceof Diagram).filter(s -> s.getEStructuralFeature() == NotationPackage.Literals.VIEW__ELEMENT).map(s -> s.getEObject()).filter(o -> o.eResource() != null).map(Diagram.class::cast).filter(filter).findAny().orElse(null);
    }
}

