/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomStateEditPartTN;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.uml2.uml.Element;

/**
 * Custom top state (frame) edit-part for UML-RT state machine diagrams.
 */
public class RTStateEditPartTN extends CustomStateEditPartTN {

	/**
	 * Initializes me with my notation view.
	 *
	 * @param view
	 *            my notation view
	 */
	public RTStateEditPartTN(View view) {
		super(view);
	}

	/**
	 * Overridden to install the {@link RTPortPositionLocator} as the constraint
	 * for connection point figures.
	 */
	@Override
	protected boolean addFixedChild(EditPart childEditPart) {
		boolean result;

		if (IRTPseudostateEditPart.isConnectionPoint(childEditPart)) {
			IRTPseudostateEditPart connPt = (IRTPseudostateEditPart) childEditPart;
			if (hasNotationView() && getNotationView().isSetElement()) {
				IBorderItemLocator locator = new RTPortPositionLocator(
						(Element) connPt.resolveSemanticElement(), getMainFigure(),
						PositionConstants.NONE, connPt.getDefaultScaleFactor());

				getBorderedFigure().getBorderItemContainer().add(connPt.getFigure(), locator);
			}

			result = true;
		} else {
			result = super.addFixedChild(childEditPart);
		}

		return result;
	}

}
