/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Christian W. Damus - Initial API and implementation
 *  
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PackageEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateChoiceEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateDeepHistoryEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateEntryPointEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateExitPointEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateJunctionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPartTN;
import org.eclipse.papyrusrt.umlrt.core.utils.ModelUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.providers.AbstractRTEditPartProvider;
import org.eclipse.uml2.uml.StateMachine;


/**
 * Provider of custom edit-parts for the UML-RT state machine diagram.
 */
public class RTStateMachineEditPartProvider extends AbstractRTEditPartProvider {

	/**
	 * Default constructor.
	 */
	public RTStateMachineEditPartProvider() {
		super(PackageEditPart.MODEL_ID);

		// Nodes
		nodeMap.put(PseudostateEntryPointEditPart.VISUAL_ID, always(RTPseudostateEntryPointEditPart.class));
		nodeMap.put(PseudostateExitPointEditPart.VISUAL_ID, always(RTPseudostateExitPointEditPart.class));
		nodeMap.put(PseudostateChoiceEditPart.VISUAL_ID, always(RTPseudostateChoiceEditPart.class));
		nodeMap.put(PseudostateJunctionEditPart.VISUAL_ID, always(RTPseudostateJunctionEditPart.class));
		nodeMap.put(PseudostateDeepHistoryEditPart.VISUAL_ID, always(RTPseudostateDeepHistoryEditPart.class));
		nodeMap.put(StateEditPart.VISUAL_ID, always(RTStateEditPart.class));
		nodeMap.put(StateEditPartTN.VISUAL_ID, always(RTStateEditPartTN.class));
	}

	/**
	 * Is the {@code element} in a real-time state machine?
	 */
	@Override
	protected boolean accept(EObject element) {
		return isInRTStateMachine(element);
	}

	private boolean isInRTStateMachine(EObject element) {
		return ModelUtils.selfAndContainersOf(element)
				.filter(StateMachine.class::isInstance).map(StateMachine.class::cast)
				.anyMatch(StateMachineUtils::isRTStateMachine);
	}
}
