/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import java.util.Optional;
import java.util.OptionalDouble;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.BorderItemHelper;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.IRTPseudostateEditPart;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;

/**
 * Default side-affixed nodes creation edit policy for RT state machine diagrams.
 */
class RTSideAffixedNodesCreationEditPolicy extends SideAffixedNodesCreationEditPolicy {

	private final BorderItemHelper<Pseudostate> pseudostateHelper = new BorderItemHelper<>(
			Pseudostate.class, this::getGraphicalHost, this::getPositionLocator);

	/**
	 * Initializes me.
	 */
	public RTSideAffixedNodesCreationEditPolicy() {
		super();
	}

	IGraphicalEditPart getGraphicalHost() {
		return (IGraphicalEditPart) getHost();
	}

	/**
	 * Extend the inherited method to capture the element being added (if any).
	 */
	@Override
	protected ICommand getSetBoundsCommand(CreateViewRequest request, ViewDescriptor descriptor) {
		return pseudostateHelper.getSetBoundsCommand(request, descriptor,
				this::getSize, super::getSetBoundsCommand);
	}

	private Optional<Dimension> getSize(Pseudostate pseudostate) {
		return getConnectionPointKind(pseudostate).map(IRTPseudostateEditPart::getDefaultSize);
	}

	protected Optional<PseudostateKind> getConnectionPointKind(Pseudostate pseudostate) {
		Optional<Pseudostate> pseudo = Optional.ofNullable(pseudostate)
				.filter(Pseudostate.class::isInstance).map(Pseudostate.class::cast);
		return pseudo.map(Pseudostate::getKind)
				.filter(k -> (k == PseudostateKind.ENTRY_POINT_LITERAL) || (k == PseudostateKind.EXIT_POINT_LITERAL));
	}

	@Override
	protected PortPositionLocator getPositionLocator() {
		return pseudostateHelper.getPositionLocator(
				this::getScaleFactor,
				super::getPositionLocator);
	}

	private OptionalDouble getScaleFactor(Pseudostate pseudostate) {
		return getConnectionPointKind(pseudostate)
				.map(kind -> OptionalDouble.of(IRTPseudostateEditPart.getDefaultScaleFactor(kind)))
				.orElseGet(OptionalDouble::empty);
	}

}
