/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.decorators;

import org.eclipse.draw2d.AbstractImageFigure;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ScaledImageFigure;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts.RTStateEditPart;
import org.eclipse.uml2.uml.State;

public class CompositeStateDecorator
extends AbstractDecorator {
    private static final int IMAGE_SIZE = 32;
    private static final int DECORATION_SIZE = 16;
    private static final IDecoratorTarget.Direction DECORATION_POSITION = IDecoratorTarget.Direction.SOUTH_EAST;
    private static final int DECORATION_OFFSET = -3;

    public CompositeStateDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    public void activate() {
        this.refresh();
    }

    public void refresh() {
        this.removeDecoration();
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        if (this.isCompositeState(editPart)) {
            IFigure editPartFigure = ((GraphicalEditPart)editPart).getFigure();
            Figure figure = new Figure();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHorizontal(true);
            flowLayout.setMinorSpacing(0);
            figure.setLayoutManager((LayoutManager)flowLayout);
            figure.add((IFigure)this.getImage());
            IMapMode mm = MapModeUtil.getMapMode((IFigure)editPartFigure);
            figure.setSize(mm.DPtoLP(16), mm.DPtoLP(16));
            this.setDecoration(this.getDecoratorTarget().addShapeDecoration((IFigure)figure, DECORATION_POSITION, -3, false));
            this.getDecoration().setToolTip((IFigure)new Label("Composite state"));
        }
    }

    boolean isCompositeState(EditPart editPart) {
        EObject semantic;
        boolean result = false;
        if (editPart instanceof RTStateEditPart && (semantic = ((RTStateEditPart)editPart).resolveSemanticElement()) instanceof State) {
            result = ((State)semantic).isComposite();
        }
        return result;
    }

    private AbstractImageFigure getImage() {
        ScaledImageFigure result = new ScaledImageFigure();
        result.setImage(Activator.getImage("ovr_composite_state"));
        result.setSize(32, 32);
        result.setScale(0.5);
        return result;
    }

    public static class Provider
    extends AbstractProvider
    implements IDecoratorProvider {
        private static final String GMF_DECORATION_KEY = "CompositeStateDecoration";

        public boolean provides(IOperation operation) {
            IDecoratorTarget target = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
            RTStateEditPart editPart = (RTStateEditPart)((Object)TypeUtils.as((Object)target.getAdapter(EditPart.class), RTStateEditPart.class));
            State state = (State)TypeUtils.as((Object)target.getAdapter(EObject.class), State.class);
            return editPart != null && state != null && StateUtils.isRTState((State)state);
        }

        public void createDecorators(IDecoratorTarget decoratorTarget) {
            View node = (View)decoratorTarget.getAdapter(View.class);
            if (node != null) {
                decoratorTarget.installDecorator((Object)GMF_DECORATION_KEY, (IDecorator)new CompositeStateDecorator(decoratorTarget));
            }
        }
    }
}

